package com.yeejoin.amos.fas.business.dao.mapper;

import com.yeejoin.amos.fas.business.bo.CheckErrorBo;
import com.yeejoin.amos.fas.business.bo.FirePlanAlarmBo;
import com.yeejoin.amos.fas.business.bo.RiskPointRpnChangeBo;
import com.yeejoin.amos.fas.business.bo.SafetyExecuteBo;
import com.yeejoin.amos.fas.business.vo.View3dNodeVo;
import com.yeejoin.amos.fas.core.common.response.Node3DVoResponse;
import com.yeejoin.amos.fas.core.common.response.RegionTreeResponse;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface View3dMapper extends BaseMapper {
    /**
     * 按类型查询点
     *
     * @param type
     * @param orgCode
     * @return
     */
    List<RegionTreeResponse> getPointByType(@Param("type") String type, @Param("orgCode") String orgCode, @Param("channelType") String channelType);

    /**
     * 获取点详情
     *
     * @param type
     * @param pointId
     * @return map
     */
    HashMap<String, Object> getPointDetailByTypeAndId(@Param("type") String type, @Param("pointId") Long pointId);

    /**
     * 统计风险上升异常数量（风险点）-日期+机构
     *
     * @param param:{type，orgCode}
     * @return Long
     */
    Long countUpperRiskPoint(Map<String, Object> param);

    /**
     * 统计巡检异常数量（不合格、漏检）-日期+机构
     *
     * @param param{}
     * @return Long
     */
    Long countCheckException(Map<String, Object> param);

    /**
     * 统计故障告警数量（不合格、漏检）-日期+机构
     *
     * @param param
     * @return
     */
    Long countFireException(Map<String, Object> param);

    /**
     * 今日安全指数详情
     *
     * @param params orgCode,date
     * @return list
     */
    List<RiskPointRpnChangeBo> getAllErrorRiskPoint(Map<String, Object> params);

    /**
     * 一周安全指数趋势查询
     *
     * @param orgCode
     * @return
     */
    List<HashMap<String, Object>> getSafetyIndexWeek(@Param("orgCode") String orgCode);

    /**
     * 今日安全指数详情
     *
     * @param params orgCode,date
     * @return list
     */
    List<CheckErrorBo> getAllErrorPatrolPoint(Map<String, Object> params);


    /**
     * 今日安全指数故障告警详情
     *
     * @param params orgCode,date
     * @return list
     */
    List<CheckErrorBo> getAllFaultAlarm(Map<String, Object> params);

    /**
     * 今日巡检统计接口
     *
     * @param orgCode
     * @return
     */
    HashMap<String, Object> getStatisticsCheck(@Param("orgCode") String orgCode);

    /**
     * 风险异常显示最新5条
     *
     * @param orgCode
     * @return
     */
    List<SafetyExecuteBo> getRiskErrorTop5();

    /**
     * 巡检异常示最新5条
     *
     * @param orgCode
     * @return
     */
    List<SafetyExecuteBo> getCheckErrorTop5();

    /**
     * 火灾告警最新5条
     *
     * @param orgCode
     * @return
     */
    List<SafetyExecuteBo> getFireAlarmTop5();

    /**
     * 设备状态最新5条
     *
     * @param orgCode
     * @return
     */
    List<SafetyExecuteBo> getEquipStatusTop5(String orgCode);

    /**
     * 按照类型查询点
     *
     * @param params {orgCode,type}
     * @return 列表
     */
    List<HashMap<String, Object>> getPintsByType(Map<String, Object> params);

    /**
     * 更新safetyIndexchangelog
     */
    void safetyIndexRefresh();

    /**
     * 重点模式设备
     *
     * @return
     */
    List<View3dNodeVo> getImpEqu3dPoints(String orgCode);

    /**
     * 异常点
     *
     * @param type
     * @param orgCode
     * @param riskSourceId 区域id
     * @return
     */
    List<View3dNodeVo> initViewErrorNode(String type, Long riskSourceId, String orgCode);

    List<Node3DVoResponse> findViewDataByType(@Param("type") String type, @Param("riskSourceId") Long riskSourceId, @Param("orgCode") String orgCode, @Param("abnormalStatus") Boolean abnormalStatus);

    Long retrieveAllCount(String type, Long riskSourceId, String inputText, String orgCode, String dataLevel, String protectObjName);

    List<HashMap<String, Object>> retrieveAll(String type, Long riskSourceId, String inputText, long start, int length, String orgCode, String dataLevel, String protectObjName);

    Long retrieve3AllCount(@Param("type")String type, @Param("riskSourceId")Long riskSourceId, @Param("areaId")Long areaId
    		, @Param("equipmentId")Long equipmentId, @Param("inputText")String inputText, @Param("orgCode")String orgCode, @Param("dataLevel")String dataLevel);

    List<HashMap<String, Object>> retrieve3All(@Param("type")String type, @Param("riskSourceId")Long riskSourceId, @Param("areaId")Long areaId, @Param("equipmentId")Long equipmentId, @Param("inputText")String inputText, @Param("start")long start
    		, @Param("length")int length, @Param("orgCode")String orgCode, @Param("dataLevel")String dataLevel);

    /**
     * 查询区域下点
     *
     * @param ids 区域ids
     * @return list
     */
    List<Map<String, Object>> getAllPointInRegions(@Param("ids") List<Long> ids);
    
    FirePlanAlarmBo getPlanAlarmInfo(@Param("batchNo")String batchNo);
}
