package com.yeejoin.amos.fas.business.dao.repository;

import com.yeejoin.amos.fas.dao.entity.EquipmentFireEquipment;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository
public interface IEquipmentFireEquipmentDao extends BaseDao<EquipmentFireEquipment, Long> {

    /**
     * 根据设备ID和配套装备ID查询
     *
     * @param equipmentId
     * @param fireEquipmentId
     * @return
     */
    @Query(value = "select count(1) from f_equipment_fire_equipment WHERE equipment_id = ?1 and fire_equipment_id = ?2", nativeQuery = true)
    int findByEqmtIdAndFireEqmtId(Long equipmentId, Long fireEquipmentId);

    List<EquipmentFireEquipment> findAllByEquipmentId(Long equipmentId);

    List<EquipmentFireEquipment> findAllByFireEquipmentId(Long fireEquipmentId);

    @Query(value = "SELECT count(1) FROM `f_equipment_fire_equipment` WHERE fire_equipment_id in ?1", nativeQuery = true)
	int countImpEquipByIds(String[] ids);

    @Transactional
    @Modifying
    @Query(value = "delete  FROM `f_equipment_fire_equipment` WHERE equipment_id = ?1", nativeQuery = true)
	void deleteByEquipmentId(Long id);

    @Query(value = "SELECT ffe.* FROM f_equipment_fire_equipment ffe LEFT JOIN wl_equipment_specific es ON ffe.fire_equipment_id = es.id LEFT JOIN wl_equipment_detail ed ON es.equipment_detail_id = ed.id WHERE ffe.equipment_id = ?1 AND ed.`code` IN ?2", nativeQuery = true)
    List<EquipmentFireEquipment> findByEquipIdAndEquipCodeIn(Long equipmentId, String[] equipCodes);

    @Query(value = "SELECT ffe.* FROM f_equipment_fire_equipment ffe LEFT JOIN wl_equipment_specific es ON ffe.fire_equipment_id = es.id WHERE ffe.equipment_id = ?1 AND es.`code` IN ?2", nativeQuery = true)
    List<EquipmentFireEquipment> findByEquipIdAndEquipSpeCodeIn(Long equipmentId, String[] equipSpeCodes);

    @Query(value = "SELECT fire_equipment_id FROM `f_equipment_fire_equipment` WHERE equipment_id IN ?1", nativeQuery = true)
    List<Long> findFireEquipmentIdsByEquipmentId(String[] equipmentIds);
}
