package com.yeejoin.amos.fas.business.event;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Async;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.time.Instant;
import java.util.List;

/**
 * @author keyong
 * @title: AsynEventListener
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2023/4/4 16:34
 */
@Configuration
public class ContingercyAsyncEventListener implements ApplicationListener<ContingecyExecEvent> {

    @Autowired
    List<EventHandler> handlers;

    @Override
    @Async
    public void onApplicationEvent(ContingecyExecEvent event) {

        if (handlers == null) return;
        RequestContext.setLoginId(event.getContext().getLoginId());
        RequestContext.setToken(event.getContext().getToken());
        RequestContext.setProduct(event.getContext().getProduct());
        RequestContext.setAppKey(event.getContext().getAppKey());
        RequestContext.setAgencyCode(event.getContext().getAgencyCode());
        RequestContext.setExeUserId(event.getContext().getExcutedUserId());

        long start = Instant.now().toEpochMilli();
        for(EventHandler handler : handlers) {
            if (handler.getEventType().equals(event.getEventType())) {
                try {
                    handler.handler(event);
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }
        long end = Instant.now().toEpochMilli();
        System.out.println("============EventHandler"+(end - start));
        RequestContext.clean();
    }
}
