package com.yeejoin.amos.fas.business.service.intfc;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.fas.business.vo.*;
import com.yeejoin.amos.fas.dao.entity.PlanDetail;
import com.yeejoin.amos.fas.dao.entity.PlanOperationRecord;
import com.yeejoin.amos.fas.exception.YeeException;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author wjk
 * @date 2021-01-14
 * 预案操作
 */
public interface IContingencyPlanService {

    String DELETE_SYNC_PLAN_DOC = "DELETE_SYNC_PLAN_DOC";
    String DELETE_SYNC_PLAN_RULE = "urule/package/remove";
    String VIEW_3D_OPEN_STATUS = "/view/3d/page";
    /**
     * 3d用戶在线redis key前缀
     */
    String KEY_VIEW_3D_PAGE = "KEY_VIEW_3D_PAGE_";

    ContingencyPlanResponseVo planStart(ContingencyPlanParamVo vo, Toke toke) throws Exception;

    ContingencyPlanResponseVo planStartFirst(String batchNo, Toke toke) throws Exception;

    ContingencyPlanParamVo equipmentScene(Long equipmentId, String riskType);

    /**
     * 创建
     *
     * @param planDetail
     * @return
     */
    @Transactional(rollbackFor = {YeeException.class, Exception.class})
    PlanDetailVo createPlan(PlanDetailVo planDetail);

    /**
     * 编辑
     *
     * @param planDetail
     * @return
     */
    @Transactional(rollbackFor = {YeeException.class, Exception.class})
    PlanDetailVo editPlan(PlanDetailVo planDetail);

    /**
     * 单个详情
     *
     * @param id
     * @return
     */
    PlanDetailVo detail(Long id);

    /**
     * 启用
     *
     * @param idList
     * @return
     */
    List<PlanDetail> activatePlan(List<Long> idList);

    /**
     * 停用
     *
     * @param idList
     * @return
     */
    List<PlanDetail> deactivatePlan(List<Long> idList);

    /**
     * 删除
     *
     * @param idList
     * @return
     */
    @Transactional(rollbackFor = {YeeException.class, Exception.class})
    Boolean delete(List<Long> idList);

    /**
     * 分页查询
     *
     * @param page                    分页
     * @param planName                预案名称
     * @param classifyId              预案类型
     * @param planRange               适用范围
     * @param editOrgName             编写部门
     * @param implementationTimeLeft  实施时间左界限
     * @param implementationTimeRight 实施时间右界限
     * @return Page
     */
    Page<PlanDetailVo> pageFilter(Page page, String planName, Long classifyId, List<String> planRange, String editOrgName, Date implementationTimeLeft, Date implementationTimeRight, String equipmentId, String category);

    /**
     * 查询预案使用的文档ID
     *
     * @return
     */
    Map<Long, Long> getPlanUsedDocs();

    /**
     * 查询预案使用的规则ID
     *
     * @return
     */
    Map<String, Long> getPlanUsedRules();

    /**
     * 查询预案使用的装备ID
     *
     * @return
     */
    Map<Long, Long> getPlanUsedEquipments();

    /**
     * 监听文档取消发布/规则、装备删除动态
     */
    void subscribeTopic();

    Map<String, Object> firstGetRecord(String batchNo);

    List<HashMap<String, Object>> getRecordList(String batchNo);

    List<HashMap<String, Object>> getBatchNoByCode(String code);

    Page recordListByPage(Page page, Long planId, String planName, List<Long> classifyId, Date startTimeLeft, Date startTimeRight, Integer executionType, Integer planPattern);

    AtomicBoolean planReset();

    List<PlanOperationRecord> getPlanStatus();

    Map<String, Object> getUserOperateCountAndPlanName(List<RoleModel> roleModelList);

    Map<String, Object> getUserOperateCountAndTaskName(List<String> list, Map<String, Object> map);

    String getPlanBatchNo();

    Page<ContingencyPlanInstanceVO> selectTaskActionPage(int current, int size, String batchNo, String runState, String updateDate, List<String> roleList, List<String> steps);

    Map<String, Object> getPlanInfo(Long planId);

    Map<String, Object> getPlanCurrentInfo();
}
