package com.yeejoin.amos.fas.business.service.intfc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.fas.business.service.model.ToipResponse;
import com.yeejoin.amos.fas.business.vo.*;
import com.yeejoin.amos.fas.dao.dto.PlanStepJsonVO;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.fas.dao.entity.TextPlan;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;

import java.util.List;
import java.util.Map;

public interface IPlanVisual3dService {

    /**
     * 上传文字预案
     *
     * @param appId       预案ID
     * @param pathNameMap 文字预案文件路径:文件名称map
     */
    void uploadTextPlan(String appId, Map<String, String> pathNameMap);

    /**
     * 根据ID获取文本预案
     *
     * @param id
     * @return
     */
    TextPlan getTextPlanInfoById(Long id);

    CommonResponse getResourceListByType(String type);

    List<Map<String, Object>> getResourceById(String type, Long id);

    List<Map<String, Object>> getResourceTypeList();

    List<TreeSubjectVo> getTextPlanBySubjectId(String appId);

    void deleteTextPlanFile(Long id);

    /**
     * 查最新在执行的批次号
     * @return
     */
	String getNewestBatchNo();


    /**
     * 查最新的批次号
     * @return
     */
	String getLastBatchNo();


    /**
     * 根据批次号获取预案步骤
     *
     * @param batchNo 批次号
     * @return 预案步骤
     */
    ToipResponse getPlanStepByBatchNo(String batchNo);
    /**
     * 根据电力装备Code获取
     *
     * @param equipCode 电力装备Code
     * @return 预案步骤
     */
    JSONArray getPlanStepByEquipCode(String equipCode);

    /**
     * 根据批次号获取预案记录
     *
     * @param batchNo 批次号
     * @return 预案记录
     */
    ToipResponse getPlaneRecordByBatchNo(String batchNo);

    /**
     * 根据批次号获取预案记录
     *
     * @param batchNo 批次号
     * @return 预案记录
     */
    ToipResponse getPlaneRecordOneByBatchNo(String batchNo);

    PlanStepVo updatePlanStep(PlanStepVo planStepVo);

//    void initPlanStep();

    void updatePlanStep(String batchNo, String stepCode, String buttonJson, String contingencyPlanId, String buttonCode, String isExecute);

    void updatePlanStepToRedis(String batchNo, String stepCode, String buttonJson, String contingencyPlanId, String buttonCode, String isExecute, String isAuto);

    Page<ContingencyPlanInstanceVO> selectDisposalActionPage(int current, int size, String batchNo, List<RoleModel> roleModelList, int dataType);

    Page<ContingencyPlanInstanceVO> selectTaskActionPage(int current, int size, String batchNo, List<String> roleModelList, int dataType);

    /**
     * 根据批次号获取预案的消息等记录
     *
     * @param batchNo
     * @return
     */
    Page<ContingencyPlanInstanceVO> getPlaneRecordByNew(Integer pageNum, Integer size, String batchNo, AgencyUserModel user);

    ContingencyPlanInstance replyMessage(AgencyUserModel user, ContingencyPlanInstance dto);

    List<ContingencyPlanInstanceVO> selectDisposalActionList(String batchNo, List<RoleModel> roleModelList, int dataType);

    List<ContingencyPlanInstanceVO> selectTaskActionList(String batchNo, List<String> roleModelList, int dataType);

    List<ContingencyPlanInstanceVO> getTaskActionList(String batchNo, int dataType);

    /**
     * 极光推送消息
     *
     * @param roleCode
     * @param messageVO
     */
    void sendMessage(String roleCode, MessageVO messageVO);

    /**
     * 获取用户名称
     *
     * @param roleCode
     */
    List<String> getUserName(String roleCode);


    /**
     * 修改动作执行状态
     *
     * @param id
     * @return
     */
    boolean updateStatusById(String id, Boolean runStatus);

    boolean updateTaskStatusById(String id, Boolean runStatus, String userName, String userId, String roleNames);

    /**
     * 修改动作执行状态-web
     * @param contingencyPlanInstance
     * @param runStatus
     * @return
     */
    ContingencyPlanInstance updateStatusByIdWeb(ContingencyPlanInstance contingencyPlanInstance, Boolean runStatus);

    List<PlanStepJsonVO> getPlanStepList(String batchNo);

    List<PlanStepJsonVO> updatePlanStepData(String stepCode, String equipCode, List<String> videos);
}
