package com.yeejoin.amos.fas.config;


import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
 
/**
 * @Description: mq生产者配置
 */
@Getter
@Setter
@ToString
@Configuration
@ConfigurationProperties(prefix = "rocketmq.producer")
public class MQProducerConfigure {
    public static final Logger LOGGER = LoggerFactory.getLogger(MQProducerConfigure.class);
 
//    private String groupName;
    @Value("${rocketmq.producer.namesrvAddr}")
    private String namesrvAddr1;

    @Value("${rocketmq.producer.namesrvAddr2}")
    private String namesrvAddr2;
    // 消息最大值
    private Integer maxMessageSize;
    // 消息发送超时时间
    private Integer sendMsgTimeOut;
    // 失败重试次数
    private Integer retryTimesWhenSendFailed;
    
    // 是否启用rocketmq
    private String sysIsUsed;

    @Value("${rocketmq.producer.groupName}")
    private String name1;

    @Value("${rocketmq.producer.groupName2}")
    private String name2;
 
    /**
     * mq 生成者配置
     * @return
     * @throws MQClientException
     */
    @Bean
    @ConditionalOnProperty(prefix = "rocketmq.producer", value = "isOnOff", havingValue = "on")
    public DefaultMQProducer defaultProducer() throws MQClientException {
    	if("on".equalsIgnoreCase(sysIsUsed)){
    		 LOGGER.info("defaultProducer 正在创建---------------------------------------");
    	        DefaultMQProducer producer = new DefaultMQProducer(name1);
    	        producer.setNamesrvAddr(namesrvAddr1);
                //实例名称：字段必须赋值 ：：：且需要区分
                producer.setInstanceName(name1);
    	        producer.setVipChannelEnabled(false);
    	        producer.setMaxMessageSize(maxMessageSize);
    	        producer.setSendMsgTimeout(sendMsgTimeOut);
    	        producer.setRetryTimesWhenSendAsyncFailed(retryTimesWhenSendFailed);
    	        producer.start();
    	        LOGGER.info("rocketmq producer server 开启成功----------------------------------");
    	        return producer;
    	}
    	 return new DefaultMQProducer(name1);
    }


    /**
     * mq 生成者配置
     * @return
     * @throws MQClientException
     */
    @Bean
    @ConditionalOnProperty(prefix = "rocketmq.producer", value = "isOnOff", havingValue = "on")
    public DefaultMQProducer defaultProducer1() throws MQClientException {
        if("on".equalsIgnoreCase(sysIsUsed)){
            LOGGER.info("defaultProducer 正在创建---------------------------------------");
            DefaultMQProducer producer = new DefaultMQProducer(name2);
            producer.setNamesrvAddr(namesrvAddr2);
            //实例名称：字段必须赋值   ：：：且需要区分
            producer.setInstanceName(name2);
            producer.setVipChannelEnabled(false);
            producer.setMaxMessageSize(maxMessageSize);
            producer.setSendMsgTimeout(sendMsgTimeOut);
            producer.setRetryTimesWhenSendAsyncFailed(retryTimesWhenSendFailed);
            producer.start();
            LOGGER.info("rocketmq producer server 开启成功----------------------------------");
            return producer;
        }
        return new DefaultMQProducer(name2);
    }
}
