package com.yeejoin.amos.fas.business.datasync;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.fas.common.enums.DataSyncOperationEnum;
import com.yeejoin.amos.fas.common.enums.DataSyncTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;

/**
 * @ProjectName: YeeAMOSPatrolRoot
 * @Package: com.yeejoin.amos.patrol.business.datasync
 * @ClassName: SyncDataMessage
 * @Author: Jianqiang Gao
 * @Description: SyncDataMessage
 * @Date: 2022/5/30 10:40
 * @Version: 1.0
 */
@Data
public class DataSyncMessage implements Serializable {

    private static final long serialVersionUID = 3950066933125606745L;

    /**
     * 唯一ID
     */
    private String uid;

    /**
     * 同步的数据类型
     */
    private DataSyncTypeEnum type;

    /**
     * 同步动作-增删改
     */
    private DataSyncOperationEnum operation;

    /**
     * 发生时间
     */
    private Long timestamp;

    /**
     * 同步数据列表
     */
    private List<Serializable> data;

    /**
     * 获取对应的redis消息key
     *
     * @return
     */
    public String redisKey() {
        assert type != null;
        return String.join("_", type.toString(), operation.toString(), uid);
    }

    /**
     * Message对象转换成字节码
     *
     * @return
     */
    public byte[] message2Bytes() {
        return JSON.toJSONString(this).getBytes(StandardCharsets.UTF_8);
    }

    /**
     * 字节码转换成Message对象
     *
     * @param messageBytes 字节码
     * @return
     */
    public static DataSyncMessage bytes2Message(byte[] messageBytes) {
        return JSON.parseObject(new String(messageBytes, StandardCharsets.UTF_8), DataSyncMessage.class);
    }
}