package com.yeejoin.amos.fas.business.util;


import com.yeejoin.amos.fas.business.bo.ContingencyOriginalDataSyncBo;
import com.yeejoin.amos.fas.business.bo.PlanDetailSyncBo;
import com.yeejoin.amos.fas.business.bo.PlanOperationRecordSyncBo;
import com.yeejoin.amos.fas.business.datasync.DataSyncMessage;
import com.yeejoin.amos.fas.common.enums.DataSyncOperationEnum;
import com.yeejoin.amos.fas.common.enums.DataSyncTypeEnum;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <h1>实体转换为同步消息对象</h1>
 *
 * @Author SingleTian
 * @Date 2021-04-01 11:17
 */
public class DataSyncUtil {

    public static <T> DataSyncMessage buildSyncMessage(T data, DataSyncOperationEnum operation) {
        return buildSyncMessage(Arrays.asList(data), operation);
    }

    public static <T> DataSyncMessage buildSyncMessage(T data, DataSyncOperationEnum operation, String sign) {
        return buildSyncMessage(Arrays.asList(data), operation, sign);
    }

    public static <T> DataSyncMessage buildSyncMessage(Collection<T> list, DataSyncOperationEnum operation) {
        T t = list.stream().findFirst().orElse(null);
        DataSyncTypeEnum type = getDataType(t, "");
        List<Serializable> data = transData(list, type);
        DataSyncMessage message = new DataSyncMessage();
        message.setUid(UUID.randomUUID().toString());
        message.setTimestamp(System.currentTimeMillis());
        message.setOperation(operation);
        message.setType(type);
        message.setData(data);
        return message;
    }

    public static <T> DataSyncMessage buildSyncMessage(Collection<T> list, DataSyncOperationEnum operation, String sign) {
        T t = list.stream().findFirst().orElse(null);
        DataSyncTypeEnum type = getDataType(t, sign);
        List<Serializable> data = transData(list, type);
        DataSyncMessage message = new DataSyncMessage();
        message.setUid(UUID.randomUUID().toString());
        message.setTimestamp(System.currentTimeMillis());
        message.setOperation(operation);
        message.setType(type);
        message.setData(data);
        return message;
    }

    private static <T> DataSyncTypeEnum getDataType(T t, String sign) {
        if (t instanceof PlanDetailSyncBo) {
            return DataSyncTypeEnum.CONTINGENCY_PLAN_DETAIL;
        } else if (t instanceof PlanOperationRecordSyncBo) {
            return DataSyncTypeEnum.CONTINGENCY_PLAN_OPERATION_RECORD;
        } else if (t instanceof ContingencyOriginalDataSyncBo) {
            return DataSyncTypeEnum.CONTINGENCY_ORIGINAL_DATA;
        } else if (t instanceof ContingencyPlanInstance) {
            return DataSyncTypeEnum.CONTINGENCY_PLAN_INSTANCE;
        } else {
            throw new RuntimeException("无法识别的类型");
        }
    }

    private static List<Serializable> transData(Collection list, DataSyncTypeEnum type) {
        switch (type) {
            case CONTINGENCY_PLAN_DETAIL: {
                return planDetailSyncBoData(list);
            }
            case CONTINGENCY_PLAN_OPERATION_RECORD: {
                return planOperationRecordSyncBoData(list);
            }
            case CONTINGENCY_ORIGINAL_DATA: {
                return contingencyOriginalDataSyncBoData(list);
            }
            case CONTINGENCY_PLAN_INSTANCE: {
                return contingencyPlanInstanceData(list);
            }
            default:
                return new ArrayList<>();
        }
    }

    private static List<PlanDetailSyncBo> planDetailSyncBoData(Collection<PlanDetailSyncBo> list) {
        return list.stream().map(i -> {
                    PlanDetailSyncBo planTaskBo = new PlanDetailSyncBo();
                    BeanUtils.copyProperties(i, planTaskBo);
                    return planTaskBo;
                }
        ).collect(Collectors.toList());
    }

    private static List<PlanOperationRecordSyncBo> planOperationRecordSyncBoData(Collection<PlanOperationRecordSyncBo> list) {
        return list.stream().map(i -> {
                    PlanOperationRecordSyncBo planTaskDetailBo = new PlanOperationRecordSyncBo();
                    BeanUtils.copyProperties(i, planTaskDetailBo);
                    return planTaskDetailBo;
                }
        ).collect(Collectors.toList());
    }

    private static List<ContingencyOriginalDataSyncBo> contingencyOriginalDataSyncBoData(Collection<ContingencyOriginalDataSyncBo> list) {
        return list.stream().map(i -> {
                    ContingencyOriginalDataSyncBo checkBo = new ContingencyOriginalDataSyncBo();
                    BeanUtils.copyProperties(i, checkBo);
                    return checkBo;
                }
        ).collect(Collectors.toList());
    }

    private static List<ContingencyPlanInstance> contingencyPlanInstanceData(Collection<ContingencyPlanInstance> list) {
        return list.stream().map(i -> {
                    ContingencyPlanInstance checkInputSyncBo = new ContingencyPlanInstance();
                    BeanUtils.copyProperties(i, checkInputSyncBo);
                    return checkInputSyncBo;
                }
        ).collect(Collectors.toList());
    }

}
