package com.yeejoin.amos.fas.business.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.fas.business.action.ContingencyAction;
import com.yeejoin.amos.fas.business.action.model.ContingencyRo;
import com.yeejoin.amos.fas.business.action.mq.WebMqttComponent;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyOriginalDataDao;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyPlanInstanceRepository;
import com.yeejoin.amos.fas.business.service.impl.RiskSourceServiceImpl;
import com.yeejoin.amos.fas.business.service.intfc.*;
import com.yeejoin.amos.fas.business.service.model.Operate;
import com.yeejoin.amos.fas.business.service.model.OperateGroup;
import com.yeejoin.amos.fas.dao.entity.ContingencyOriginalData;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.fas.dao.entity.Equipment;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.*;

/**
 * @author keyong
 * @title: FireContingencyHandler
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2023/4/4 16:33
 */
@Component
public class BizContingencyHandler implements EventHandler{




    @Autowired
    private IContingencyPlanInstanceRepository repository;

    @Autowired
    IContingencyOriginalDataDao iContingencyOriginalDataDao;


    @Autowired
    private RedisTemplate redisTemplate;


    @Autowired
    IRocketMQService rocketMQService;

    @Value("${station.name}")
    private String stationName;

    @Autowired
    private ContingencyInstanceInfoService contingencyInstanceInfoService;

    @Autowired
    private IContingencyInstance contingencyInstance;

    @Autowired
    private WebMqttComponent webMqttComponent;

    @Autowired
    private IPlanVisual3dService planVisual3dService;

    @Autowired
    private IPlanStepService planStepService;

    private static Map<String, String> stepMap = new HashMap<>();


    @Value("${spring.application.name}")
    private String serviceName;

    @Autowired
    ContingencyAction contingencyAction;

    @Override
    @Transactional
    public void handler(ContingecyExecEvent event) throws Exception {

        /**
         * TODO 只处理预案业务数据更新
         */

        updateData(event);
    }

    @Override
    public String getEventType() {
        return EventType.UPDATE_CONTINGENCY_DATE.name();
    }

    public void updateData(ContingecyExecEvent event) throws Exception {
        try {
//            fire(event.getPlanExecute().getBatchNo(),
//                    event.getPlanExecute().getStepCode(),
//                    event.getPlanExecute().getContingencyPlanId(),
//                    event.getPlanExecute().getButtonCode(),
//                    event.getPlanExecute().getConfirm(),
//                    event.getPlanExecute().getStepState());

            //  更新redis中预案步骤数据
            planVisual3dService.updatePlanStepToRedis(
                    event.getPlanExecute().getBatchNo(),
                    event.getPlanExecute().getStepCode(),
                    event.getPlanExecute().getButtonJson(),
                    event.getPlanExecute().getContingencyPlanId(),
                    event.getPlanExecute().getButtonCode(),
                    event.getPlanExecute().getIsExecute(),
                    event.getPlanExecute().getIsAuto());
            setButtonExecuted( event.getPlanExecute().getBatchNo(),
                    event.getPlanExecute().getContingencyPlanId(),
                    event.getPlanExecute().getButtonCode(),
                    event.getPlanExecute().getConfirm(),
                    RequestContext.getLoginId());
        } catch (Exception e) {
            throw e;
        } finally {
            // 更新记录之后发送消息刷新
            String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
            Map<String, Object> result = new HashMap<>();
            result.put("contingency", new ContingencyRo());
            result.put("msgContext", Collections.EMPTY_MAP);
            result.put("msgType", "refreshRecord");
            webMqttComponent.publish(topic, JSON.toJSONString(result));
        }
    }


    @Transactional
    public void setButtonExecuted(String batchNo, String contingencyPlanId, String code, String buttonState,String user) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ContingencyPlanInstance contingencyPlanInstance = contingencyInstance.getMessageById(contingencyPlanId);
        if (contingencyPlanInstance != null) {
            if ("OPERATE".equals(contingencyPlanInstance.getRecordType())) {

                String operateJson = contingencyPlanInstance.getContent();
                if(user != null) {
                    contingencyPlanInstance.setStartUserName(user);
                }
                OperateGroup operateGroup = objectMapper.readValue(operateJson, OperateGroup.class);

                List<Operate> operates = operateGroup.getOperate();
                if (!CollectionUtils.isEmpty(operates)) {
                    for (Operate operate : operates) {
//                        if (code.equals(operate.getCode()) && ("executed".equals(operate.getState()) || "disable".equals(operate.getState()))) {
                        if (code.equals(operate.getCode()) && ("executed".equals(operate.getState()))) {
                            if ("FIRE_CANCEL".equals(code) || "END_EMERGENCY".equals(code)) {
                                redisTemplate.delete(RiskSourceServiceImpl.cacheKeyForCanBeRunning());
                            }
                            throw new Exception("请勿重复操作.");
                        }
                    }
                }

                operateJson = objectMapper.writeValueAsString(operateGroup);
                contingencyPlanInstance.setContent(operateJson);
                if (buttonState.equals("CONFIRM")) {
                    contingencyPlanInstance.setRunstate(true);
                    if (code.endsWith("_NOT")) {
                        contingencyPlanInstance.setRunstate(false);
                        //  满足移动端确认按钮展示，确认后，多按钮json只保留最后一个按钮
                        planVisual3dService.updateStatusByIdWeb(contingencyPlanInstance, false);
                    } else {
                        //  满足移动端确认按钮展示，确认后，多按钮json只保留最后一个按钮
                        planVisual3dService.updateStatusByIdWeb(contingencyPlanInstance, true);
                    }
                }
                ContingencyPlanInstance instance = repository.save(contingencyPlanInstance);
                if (buttonState.equals("CONFIRM")) {
                    String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
                    Map<String, Object> map = new HashMap<>();
                    map.put("contingency", new ContingencyRo());
                    map.put("msgContext", Collections.EMPTY_MAP);
                    map.put("msgType", "operateConfirmMessage");
                    webMqttComponent.publish(topic, JSON.toJSONString(map));
                }
                if (buttonState.equals("CANCEL_0")) {
                    String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
                    System.out.println("=========================> 规则触发  初始化动作 initOperate ");
                    Map<String, Object> map = new HashMap<>();
                    map.put("contingency", new ContingencyRo());
                    map.put("msgContext", Collections.EMPTY_MAP);
                    map.put("msgType", "initOperate");
                    webMqttComponent.publish(topic, JSON.toJSONString(map));
                }
                //  异步数据同步之消息发送
                //contingencyPlanInstanceDataSync(instance);
                if ("CONFIRM".equals(buttonState) && ("FIRE_CANCEL".equals(code) || "END_EMERGENCY".equals(code))) {
                    redisTemplate.delete(RiskSourceServiceImpl.cacheKeyForCanBeRunning());
                    // 应急处置中断，初始化planStep，json数据
                    planStepService.initPlanStep();
                    // 应急处置中断，更新预案信息表结束时间
                    contingencyInstanceInfoService.updateEndTimeById(batchNo);
                }
            }
        }

        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                String planStep = "";
                if (redisTemplate.hasKey("planStep")) {
                    planStep = Objects.requireNonNull(redisTemplate.opsForValue().get("planStep")).toString();
                } else {
                    planStep = planStepService.getPlanStep();
                }
                JSONArray objects = JSON.parseArray(planStep);
                String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
                Map<String, Object> result = new HashMap<>();
                result.put("contingency", new ContingencyRo());
                result.put("msgContext", Collections.EMPTY_MAP);
                result.put("msgType", "getStepList");
                result.put("planStep", objects);
                webMqttComponent.publish(topic, JSON.toJSONString(result));
            }
        });
    }


    public void fire(String batchNo, String stepCode, String contingencyPlanId, String buttonCode, String buttonState, String stepStateOnbutton) throws Exception {
        //火灾误报
        ContingencyOriginalData contingencyOriginalData = iContingencyOriginalDataDao.findByBatchNo(batchNo);

        String stepKey = batchNo + "_" + stepCode;
        if (stepMap.get(stepKey) == null)
            stepMap.put(stepKey, "");
        Equipment equipment;
        if (contingencyOriginalData != null) {
            contingencyOriginalData.setConfirm(buttonState);
            contingencyOriginalData.setRunstep(false);
            if (contingencyOriginalData.getStepState() == null)
                contingencyOriginalData.setStepState("");

            if ("CONFIRM".equals(buttonState)
                    && !contingencyOriginalData.getStepState().contains(stepStateOnbutton)
                    && stepCode.equals(contingencyOriginalData.getStep()))
                contingencyOriginalData.setStepState(contingencyOriginalData.getStepState() + stepStateOnbutton);

            //请求中的步骤小于以保存的步骤
            if (Integer.parseInt(stepCode) < Integer.parseInt(contingencyOriginalData.getStep())) {
                contingencyOriginalData.setRunstep(true);
            }

            if (Integer.parseInt(stepCode) > Integer.parseInt(contingencyOriginalData.getStep())) {
                contingencyOriginalData.setStepState(stepStateOnbutton);
            }
            iContingencyOriginalDataDao.updateByButton(
                    contingencyOriginalData.getConfirm(),
                    contingencyOriginalData.getRunstep(),
                    contingencyOriginalData.getStepState(),
                    batchNo
            );
        } else {
            throw new Exception("数据异常,请联系管理员.");
        }
    }

}
