package com.yeejoin.amos.fas.dao.entity;

import lombok.Data;
import org.springframework.data.annotation.CreatedDate;

import javax.persistence.*;
import java.util.Date;

@Data
@Entity
@Table(name="c_emergency_task_role")
@NamedQuery(name="EmergencyTaskRole.findAll", query="SELECT e FROM EmergencyTaskRole e")
public class EmergencyTaskRole {
    /**
     * id
     */
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name = "id",nullable=false,unique=true)
    private Long id;

    @CreatedDate
    @Column(name="create_date")
    private Date createDate = new Date();

    /**
     * 角色名称
     */
    @Column(name="name")
    private String name;

    /**
     * 角色编码
     */
    @Column(name="code")
    private String code;

    /**
     * 排序字段
     */
    @Column(name="sort")
    private Long sort;

    /**
     * 是否删除字段
     */
    @Column(name="is_delete")
    private Integer isDelete = 0;

    /**
     * 备注
     */
    @Column(name="remark")
    private String remark;

    /**
     * 版次
     */
    @Column(name="creater")
    private String creater;

    /**
     * 机构编码
     */
    @Column(name="biz_org_code")
    private String bizOrgCode;

    /**
     * 机构名称
     */
    @Column(name="biz_org_name")
    private String bizOrgName;
}
