package com.yeejoin.amos.fas.business.action;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.component.rule.MethodParam;
import com.yeejoin.amos.component.rule.RuleActionBean;
import com.yeejoin.amos.component.rule.RuleMethod;
import com.yeejoin.amos.fas.business.action.el.ELEvaluationContext;
import com.yeejoin.amos.fas.business.action.model.ContingencyEvent;
import com.yeejoin.amos.fas.business.action.model.ContingencyRo;
import com.yeejoin.amos.fas.business.action.model.DeviceRo;
import com.yeejoin.amos.fas.business.action.mq.WebMqttComponent;
import com.yeejoin.amos.fas.business.action.result.ActionResult;
import com.yeejoin.amos.fas.business.action.result.SafteyPlanResult;
import com.yeejoin.amos.fas.business.action.result.message.AbstractActionResultMessage;
import com.yeejoin.amos.fas.business.action.util.ContingencyLogPublisher;
import com.yeejoin.amos.fas.business.dao.mapper.PlanDetailMapper;
import com.yeejoin.amos.fas.business.dao.mapper.PlanOperationRecordMapper;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyPlanInstanceRepository;
import com.yeejoin.amos.fas.business.dao.repository.IPlanDetailDao;
import com.yeejoin.amos.fas.business.dao.repository.IPlanOperationRecordDao;
import com.yeejoin.amos.fas.business.feign.RemoteSecurityService;
import com.yeejoin.amos.fas.business.service.impl.RuleRunigSnapshotServiceImpl;
import com.yeejoin.amos.fas.business.service.intfc.*;
import com.yeejoin.amos.fas.business.service.model.ToipResponse;
import com.yeejoin.amos.fas.business.util.JSONUtil;
import com.yeejoin.amos.fas.business.vo.*;
import com.yeejoin.amos.fas.common.enums.ContingencyPlanStatusEnum;
import com.yeejoin.amos.fas.common.enums.PlanRecordStatusEnum;
import com.yeejoin.amos.fas.common.enums.PlanTypeEnum;
import com.yeejoin.amos.fas.core.enums.NumberEnum;
import com.yeejoin.amos.fas.core.util.DateUtil;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.fas.dao.entity.Equipment;
import com.yeejoin.amos.fas.dao.entity.PlanDetail;
import com.yeejoin.amos.fas.dao.entity.PlanOperationRecord;
import com.yeejoin.amos.fas.datasync.bo.PlanDetailSyncBo;
import com.yeejoin.amos.fas.datasync.bo.PlanOperationRecordSyncBo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import static org.typroject.tyboot.core.foundation.context.RequestContext.*;


@Component
@RuleActionBean(beanLabel = "动态预案")
public class ContingencyAction implements CustomerAction {


    private static String PACKAGEURL = "com.yeejoin.amos.fas.business.action.result.message.";

    public static final Logger log = LoggerFactory.getLogger(ContingencyAction.class);

    @Autowired
    private WebMqttComponent webMqttComponent;

    @Value("${auto-sys.push.type}")
    private String pushType;
    @Value("${spring.application.name}")
    private String serviceName;

    @Value("${station.name}")
    private String stationName;

    @Autowired
    private IContingencyInstance iContingencyInstance;

    @Autowired
    private ContingencyLogPublisher contingencyLogPublisher;

    @Autowired
    private IEquipmentService equipmentService;

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    IRocketMQService rocketMQService;

    @Autowired
    private IContingencyInstance contingencyInstance;

    @Autowired
    private PlanOperationRecordMapper planOperationRecordMapper;

    @Autowired
    private PlanDetailMapper planDetailMapper;

    @Autowired
    private IPlanVisual3dService planVisual3dService;

    @Autowired
    private ContingencyInstanceInfoService contingencyInstanceInfoService;

    @Autowired
    private IContingencyPlanInstanceRepository contingencyPlanInstanceRepository;

    @Autowired
    private IPlanStepService planStepService;

    @Lazy
    @Autowired
    private IEmergencyTaskService emergencyTaskService;

    @Value("${rocket-plan-topic}")
    private String rocketTopic;

    @Value("${maparea.action.is-area}")
    private String isArea;

    private static Map<String, String> OPERATE_RECORD_ID = new HashMap<>();

    private static Map<String, ContingencyPlanInstance> OPERATE_CONTINGENCYPLAN_INSTANCE = new HashMap<>();

    private static Map<String, Map<String, String>> stringStringMap = new HashMap<>();
    static SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");

    public static ConcurrentHashMap<String, Map<String, Object>> pointCache = new ConcurrentHashMap<>();

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Autowired
    private IPlanDetailDao planDetailDao;
    @Autowired
    private IPlanOperationRecordDao planOperationRecordDao;
    @Autowired
    private com.yeejoin.amos.component.rule.RuleTrigger ruleTrigger;
    @Autowired
    private IEquipmentFireEquipmentService equipmentFireEquipmentService;

    @Autowired
    private IPlanStepService iPlanStepService;

    /**
     * @param stepCode     当前步骤编号
     * @param stepName     当前步骤名称
     * @param nextStepCode 下一步编号
     * @param nextStepName 下一步名称
     * @param paramObj     预案对象
     */
    @RuleMethod(methodLabel = "步骤更新", project = "换流站消防专项预案")
    public void stepInfo(@MethodParam(paramLabel = "当前步骤编号") String stepCode, @MethodParam(paramLabel = "当前步骤名称") String stepName, @MethodParam(paramLabel = "下一步编号") String nextStepCode, @MethodParam(paramLabel = "下一步名称") String nextStepName, @MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            stopSnapshop(contingencyRo);

            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();
            ArrayList list = new ArrayList();
            HashMap step = new HashMap();

            step.put("stepCode", stepCode);
            step.put("stepName", stepName);

            HashMap nextmap = new HashMap();
            nextmap.put("stepCode", nextStepCode);
            nextmap.put("stepName", nextStepName);
            list.add(step);
            list.add(nextmap);

            tempmap1.put("step", list);
            tempmap1.put("preStep", new HashMap());
            result.add(tempmap1);
            log.info("步骤更新(new)" + JSONObject.toJSONString(result));
            this.sendcmd("steparea", contingencyRo, result);
        }
    }

    /**
     * @param stepCode 当前步骤编号
     * @param paramObj 预案对象
     */
    @RuleMethod(methodLabel = "步骤更新(旧)", project = "换流站消防专项预案")
    public void stepInfoOld(@MethodParam(paramLabel = "当前编号") String stepCode, @MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        stopSnapshop(contingencyRo);

        SafteyPlanResult result = new SafteyPlanResult();
        this.sendcmd("steparea", contingencyRo, result);
    }

    public void sendcmdT(String msgType, Object contingency, SafteyPlanResult result) {

        ToipResponse toipResponse = new ToipResponse();
        toipResponse.setMsgType(msgType);
        toipResponse.setMsgContext(result.toJson());
        toipResponse.setContingency(contingency);

        String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
        log.info(String.format("mqtt[%s]:【 %s 】", topic, toipResponse.toJsonStr()));
        webMqttComponent.publish(topic, toipResponse.toJsonStr());
    }

    public void sendcmd(String msgType, Object contingency, SafteyPlanResult result) {
        ContingencyRo ro = (ContingencyRo) contingency;
        ro.setTelemetryMap(null);
        ro.setTelesignallingMap(null);
        Constructor<?> constructor;
        try {
            constructor = Class.forName(PACKAGEURL + result.getClass().getSimpleName() + "Message").getConstructor(ActionResult.class);
            AbstractActionResultMessage<?> action = (AbstractActionResultMessage<?>) constructor.newInstance(result);
            if ("mqtt".equals(pushType.toLowerCase(Locale.ENGLISH))) {
                ToipResponse toipResponse = action.buildResponse(msgType, contingency, result.toJson());
                String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
                log.info(String.format("mqtt[%s]:【 %s 】", topic, toipResponse.toJsonStr()));
                webMqttComponent.publish(topic, toipResponse.toJsonStr());

                ContingencyEvent event = new ContingencyEvent(this);
                event.setMsgBody(toipResponse.toJsonStr());
                event.setTopic(topic);
                event.setMsgType(msgType);
                event.setContingency(contingency);
                contingencyLogPublisher.publish(event);

                // 将预案的确认消息发送至中心级
                if ("CONFIRM".equals(ro.getConfirm())) {
                    log.info("RocketMQ发送的主题是: " + rocketTopic + ", 消息体是: " + toipResponse.toJsonStr() + "！");
                    try {
                        rocketMQService.sendMsg(rocketTopic, "plan_process", toipResponse);
                    } catch (Exception e) {
                        log.error(e.getMessage(), e);
                        throw new RuntimeException("RocketMQ消息发送失败！");
                    }

                }
            } else if ("websocket".equals(pushType.toLowerCase(Locale.ENGLISH))) {
                action.execute(msgType, contingency);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendweb(String msgType, Object contingency, SafteyPlanResult result) {
        ContingencyRo ro = (ContingencyRo) contingency;
        ro.setTelemetryMap(null);
        ro.setTelesignallingMap(null);
        Constructor<?> constructor;
        try {
            constructor = Class.forName(PACKAGEURL + result.getClass().getSimpleName() + "Message").getConstructor(ActionResult.class);
            AbstractActionResultMessage<?> action = (AbstractActionResultMessage<?>) constructor.newInstance(result);
            ToipResponse toipResponse = action.buildResponse(msgType, contingency, result.toJson());
            String topic = String.format("/%s/%s/%s", serviceName, stationName, "numberPlan");
            log.info(String.format("mqtt[%s]:【 %s 】", topic, toipResponse.toJsonStr()));
            webMqttComponent.publish(topic, toipResponse.toJsonStr());
            ContingencyEvent event = new ContingencyEvent(this);
            event.setMsgBody(toipResponse.toJsonStr());
            event.setTopic(topic);
            event.setMsgType(msgType);
            event.setContingency(contingency);
            contingencyLogPublisher.publish(event);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * @param stepCode 当前步骤编号
     * @param paramObj 预案对象
     */
    @RuleMethod(methodLabel = "步骤更新保存", project = "换流站消防专项预案")
    public void saveStepInfo(@MethodParam(paramLabel = "当前编号") String stepCode, @MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            iContingencyInstance.updateStep(stepCode, contingencyRo.getBatchNo());
        }
    }


    /**
     * @param content  消息内容
     * @param paramObj 预案对象
     */
    @RuleMethod(methodLabel = "执行记录", project = "换流站消防专项预案")
    @Transactional
    public void messageRecord(@MethodParam(paramLabel = "消息内容") String content, @MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            stopSnapshop(contingencyRo);
            Map<String, Object> params = contingencyRo.getParams();

            RequestContext.setAppKey(params.getOrDefault("appKey", "").toString());
            RequestContext.setProduct(params.getOrDefault("product", "").toString());
            RequestContext.setToken(params.getOrDefault("token", "").toString());

            redisTemplate.opsForValue().set("action:appKey", params.getOrDefault("appKey", "").toString());
            redisTemplate.opsForValue().set("action:product", params.getOrDefault("product", "").toString());
            redisTemplate.opsForValue().set("action:token", params.getOrDefault("token", "").toString());

            //转换content中的变量
            content = instedParams(content, contingencyRo);
            iContingencyInstance.createInstanceRecord(contingencyRo.getBatchNo(), "", "DEFAULT", content, "MESSAGE", "");

            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();
            try {
                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                List<ContingencyPlanInstance> list = iContingencyInstance.queryForTimeLine(contingencyRo.getBatchNo(), "MESSAGE");
                ArrayList records = new ArrayList<>();
                if (!ObjectUtils.isEmpty(list)) {
                    list.forEach(action -> {
                        HashMap map = new HashMap();
                        map.put("time", sdf1.format(action.getCreateDate().getTime()));
                        map.put("stepName", action.getContent());
                        records.add(map);
                    });
                }
                tempmap1.put("content", records);
                tempmap1.put("status", PlanRecordStatusEnum.OPERATION.getCode());
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            result.add(tempmap1);
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
                @Override
                public void afterCommit() {
                    sendcmd("recordarea", paramObj, result);
                    sendweb("recordarea", paramObj, result);
                }
            });
        }
    }

    /**
     * <pre>
     * 智能辅助
     * </pre>
     *
     * @param step     当前步骤
     * @param icon     图标
     * @param title    标题
     * @param image    图片集合
     * @param table    表格
     * @param content  内容
     * @param paramObj 预案对象
     */
    @RuleMethod(methodLabel = "智能辅助", project = "换流站消防专项预案")
    public void help(@MethodParam(paramLabel = "当前步骤") String step, @MethodParam(paramLabel = "图标") String icon, @MethodParam(paramLabel = "标题") String title, @MethodParam(paramLabel = "图片集") String image, @MethodParam(paramLabel = "表格数据") String table, @MethodParam(paramLabel = "文本内容") String content, @MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            stopSnapshop(contingencyRo);

            //转换智能辅助中的变量
            content = instedParams(content, contingencyRo);

            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();

            tempmap1.put("icon", icon);
            tempmap1.put("step", step);
            tempmap1.put("title", title);
            tempmap1.put("content", content);
            tempmap1.put("image", image);
            tempmap1.put("table", table);
            iContingencyInstance.createInstanceRecord(contingencyRo.getBatchNo(), "", "DEFAULT", JSONUtil.toJson(tempmap1), "HELPAREA", "");
            result.add(tempmap1);

            this.sendcmd("helparea", paramObj, result);
            String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
            Map<String, Object> map = new HashMap<>();
            map.put("contingency", new ContingencyRo());
            map.put("msgContext", Collections.EMPTY_MAP);
            map.put("msgType", "refreshTaskRecord");
            webMqttComponent.publish(topic, JSON.toJSONString(map));
        }
    }


    private String instedParams(String content, ContingencyRo contingencyRo) {
        Field[] fields = contingencyRo.getClass().getDeclaredFields();
        Method getMethod = null;
        try {
            for (Field field : fields) {
                if (field.getName().equals("serialVersionUID")) continue;
                String fileNameInMethod = String.valueOf(field.getName().charAt(0)).toUpperCase() + field.getName().substring(1);
                getMethod = contingencyRo.getClass().getMethod("get" + fileNameInMethod);
                String value = String.valueOf(getMethod.invoke(contingencyRo));
                content = content.replaceAll("\\$\\{" + field.getName() + "}", value);
            }

            content = getNative(content);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public String getNative(String str) {
        Pattern p = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher m = p.matcher(str);
        while (m.find()) {
            String parameter = m.group();

            Object parametervalue = ELEvaluationContext.getValue(parameter.substring(1, parameter.length() - 1));
            if (parametervalue != null)
                str = str.replace(parameter, parametervalue != null ? parametervalue.toString() : null);
        }
        return str;
    }

    /**
     * 交互动作
     *
     * @param actionName 动作名称
     * @param icon       图标
     * @param tips       提示信息
     * @param buttonJson 按钮json字符串
     * @param paramObj   预案对象
     */
    @RuleMethod(methodLabel = "交互动作", project = "换流站消防专项预案")
    @Transactional
    public void operation(@MethodParam(paramLabel = "动作名称") String actionName, @MethodParam(paramLabel = "图标") String icon, @MethodParam(paramLabel = "提示信息") String tips, @MethodParam(paramLabel = "按钮json字符串") String buttonJson, @MethodParam(paramLabel = "预案对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        String buttonCode = contingencyRo.getButtonCode();
        String stepCode = contingencyRo.getStep();

        if (StringUtils.isBlank(buttonCode)) {
            //  根据步骤，取按钮编码
            List<PlanStepJsonVO> planStepJsonVOList = planStepService.getPlanStepJsonVOS();
            List<PlanStepJsonVO> collect = planStepJsonVOList.stream().filter(x -> x.getStepCode().equals(stepCode)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                buttonCode = collect.get(0).getButtonCode();
            }
        }
        if (!findByBatchNoAndStatus(batchNo)) {
            stopSnapshop(contingencyRo);

            //转换content中的变量
            tips = instedParams(tips, contingencyRo);

            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();

            ContingencyPlanInstance contingencyPlanInstance = getContingencyPlan(contingencyRo.getBatchNo(), actionName, icon, tips, buttonJson);
            String contingencyPlanId = contingencyPlanInstance.getId();
            tempmap1.put("actionName", actionName);
            tempmap1.put("icon", icon);
            tempmap1.put("tips", tips);
            tempmap1.put("button", buttonJson);
            tempmap1.put("caseId", contingencyPlanId);
            result.add(tempmap1);
            this.sendcmd("optionarea", paramObj, result);

            // 默认调用当前动作
            try {
                ButtonJsonVO buttonJsonVO = JSONObject.parseObject(buttonJson, ButtonJsonVO.class);
                Map<String, Object> map = buttonJsonVO.getOperate().get(buttonJsonVO.getOperate().size() - 1);
                iContingencyInstance.fire(batchNo, buttonJsonVO.getStepCode(), buttonJson, contingencyPlanId, map.get("code").toString(), "CANCEL_0", "A", "false", "false", getToken(), getProduct(), getAppKey(), null);
            } catch (Exception e) {
                log.error("optionarea 加入队列失败-->" + e.getMessage());
            }


        }
    }

//    private boolean sendButton(String batchNo, String contingencyPlanId, String equipmentId, String actionName, String buttonJson) {
//        ObjectMapper objectMapper = new ObjectMapper();
//        try {
//            Map button = objectMapper.readValue(buttonJson, Map.class);
//            Map operateInstance = (Map) ((List) button.get("operate")).get(0);
//            ContingencyDeviceStatus contingencyDeviceStatus = new ContingencyDeviceStatus();
//            contingencyDeviceStatus.setActionName(actionName);
//            contingencyDeviceStatus.setButtonCode(String.valueOf(operateInstance.get("code")));
//            contingencyDeviceStatus.setConfirm("CONFIRM");
//            contingencyDeviceStatus.setContingencyPlanId(contingencyPlanId);
//            contingencyDeviceStatus.setEquipmentId(equipmentId);
//            contingencyDeviceStatus.setStepCode(String.valueOf(button.get("stepCode")));
//            contingencyDeviceStatus.setStepState(String.valueOf(operateInstance.get("stepState")));
//            riskSourceService.queryContingencyDeviceStatus(contingencyDeviceStatus);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        return false;
//    }


    /**
     * 保存交互动作
     *
     * @param actionName 动作名称
     * @param icon       图标
     * @param tips       提示信息
     * @param buttonJson 按钮json字符串
     * @param paramObj   预案对象
     */
    @RuleMethod(methodLabel = "保存交互动作", project = "换流站消防专项预案")
    public void saveOperation(@MethodParam(paramLabel = "动作名称") String actionName, @MethodParam(paramLabel = "图标") String icon, @MethodParam(paramLabel = "提示信息") String tips, @MethodParam(paramLabel = "按钮json字符串") String buttonJson, @MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            stopSnapshop(contingencyRo);

            //转换content中的变量
            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();
            try {
                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                List<ContingencyPlanInstance> list = iContingencyInstance.queryForTimeLine(contingencyRo.getBatchNo(), "MESSAGE");
                ArrayList records = new ArrayList<>();
                if (!ObjectUtils.isEmpty(list)) {
                    list.forEach(action -> {
                        HashMap map = new HashMap();
                        map.put("time", sdf1.format(action.getCreateDate().getTime()));
                        map.put("stepName", action.getContent());
                        records.add(map);
                    });
                }
                tempmap1.put("content", records);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            result.add(tempmap1);
            this.sendcmd("recordarea", paramObj, result);
        }
    }

    private String getContingencyPlanId(String batchNo, String actionName, String icon, String tips, String buttonJson) {
        String cacheKey = batchNo + actionName;
        String contingencyPlanId = null;
        ContingencyPlanInstance contingencyPlanInstance = null;
        if (OPERATE_RECORD_ID.get(cacheKey) == null) {
            contingencyPlanInstance = iContingencyInstance.createInstanceRecord(batchNo, actionName, "DEFAULT", buttonJson, "OPERATE", icon);
            contingencyPlanId = contingencyPlanInstance.getId();
            OPERATE_RECORD_ID.put(cacheKey, contingencyPlanId);
        } else {
            contingencyPlanId = OPERATE_RECORD_ID.get(cacheKey);
            OPERATE_RECORD_ID.remove(cacheKey);
        }
        return contingencyPlanId;
    }

    private ContingencyPlanInstance getContingencyPlan(String batchNo, String actionName, String icon, String tips, String buttonJson) {
        String cacheKey = batchNo + actionName;
        ContingencyPlanInstance contingencyPlanInstance = null;
        if (OPERATE_CONTINGENCYPLAN_INSTANCE.get(cacheKey) == null) {
            contingencyPlanInstance = iContingencyInstance.createInstanceRecord(batchNo, actionName, "DEFAULT", buttonJson, "OPERATE", icon);
            OPERATE_CONTINGENCYPLAN_INSTANCE.put(cacheKey, contingencyPlanInstance);
        } else {
            contingencyPlanInstance = OPERATE_CONTINGENCYPLAN_INSTANCE.get(cacheKey);
            OPERATE_CONTINGENCYPLAN_INSTANCE.remove(cacheKey);
        }
        return contingencyPlanInstance;
    }


    /**
     * 地图动作推送
     *
     * @param actionName 动作名称标识
     * @param paramObj   预案对象
     */
    @RuleMethod(methodLabel = "地图动作", project = "换流站消防专项预案")
    public void mapAction(@MethodParam(paramLabel = "动作名称标识") String actionName, @MethodParam(paramLabel = "参数") String paramJSON, @MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            stopSnapshop(contingencyRo);

            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();

            tempmap1.put("key", actionName);
            tempmap1.put("content", paramJSON);
            if (isArea.contains(paramJSON)) {
                tempmap1.put("isArea", true);
            } else {
                tempmap1.put("isArea", false);
            }
            result.add(tempmap1);
            this.sendcmd("maparea", paramObj, result);
        }
    }

    @RuleMethod(methodLabel = "地图动画", project = "换流站消防专项预案")
    public void mapCartoonAction(@MethodParam(paramLabel = "动作名称标识") String actionName, @MethodParam(paramLabel = "动作类型") String actionType, @MethodParam(paramLabel = "动作类型参数") String paramJSON, @MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            stopSnapshop(contingencyRo);
            String parameter = instedParams(paramJSON, contingencyRo);

            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();

            tempmap1.put("key", actionName);
            tempmap1.put("content", actionType);
            tempmap1.put("parameter", parameter);
            result.add(tempmap1);
            this.sendcmd("maparea", paramObj, result);
        }
    }

    /**
     * 顶部消息提示
     *
     * @param content     消息内容
     * @param messageType 消息类型 messageType 黑色框消息类型CONTINGENCY,，滚动消息：CURRENTMESSAGE
     * @param paramObj    预案对象
     */
    @RuleMethod(methodLabel = "消息提示", project = "换流站消防专项预案")
    public void topMessage(@MethodParam(paramLabel = "标题") String title, @MethodParam(paramLabel = "内容") String content, @MethodParam(paramLabel = "图标") String icon, @MethodParam(paramLabel = "类型") String messageType, @MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            stopSnapshop(contingencyRo);

            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();
            //转换content中的变量
            content = instedParams(content, contingencyRo);

            tempmap1.put("content", content);
            tempmap1.put("type", messageType);//消息类型 messageType 黑色框消息类型 CONTINGENCY,，滚动消息：CURRENTMESSAGE
            tempmap1.put("title", title);
            tempmap1.put("icon", icon);
            result.add(tempmap1);

            this.sendcmd("message", paramObj, result);
        }
    }

    /**
     * 启动预案
     *
     * @param paramObj 预案对象
     */
    @RuleMethod(methodLabel = "启动预案", project = "换流站消防专项预案")
    public void startPlan(@MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        stopSnapshop(contingencyRo);

        SafteyPlanResult result = new SafteyPlanResult();
        Map<String, Object> tempmap1 = new HashMap<>();

        tempmap1.put("type", "event");
        tempmap1.put("content", "startPlan");
        result.add(tempmap1);

        this.sendcmd("message", paramObj, result);
        redisTemplate.opsForValue().set("contingencyRo", contingencyRo);
    }


    /**
     * 启动预案
     *
     * @param paramObj 预案对象
     */
    @RuleMethod(methodLabel = "结束预案", project = "换流站消防专项预案")
    public void stopPlan(@MethodParam(paramLabel = "对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        stopSnapshop(contingencyRo);
        String batchNo = contingencyRo.getBatchNo();

        SafteyPlanResult result = new SafteyPlanResult();
        Map<String, Object> tempmap1 = new HashMap<>();

        tempmap1.put("type", "event");
        tempmap1.put("content", "stopPlan");
        //数字预案结束状态
        tempmap1.put("status", PlanRecordStatusEnum.COMPLETE.getCode());
        result.add(tempmap1);

        //  结束预案，更新设备重点设备参数
        if (contingencyRo != null) {
            Equipment equipment = equipmentService.queryOne(Long.parseLong(contingencyRo.getEquipmentId()));
            if (equipment != null) {
                equipment.setEndTime(DateUtil.getDateNow());
                equipment.setReserveSource(NumberEnum.ZERO.getValue());
                equipment.setStatus(NumberEnum.ZERO.getValue());
                equipmentService.save(equipment);
            }
        }

        //  结束预案 更新预案记录表,预案状态
        PlanOperationRecord PlanOperationRecord = planOperationRecordDao.findByBatchNo(batchNo);
        if (PlanOperationRecord != null && PlanOperationRecord.getStatus() == PlanRecordStatusEnum.OPERATION.getCode()) {
            PlanOperationRecord.setStatus(PlanRecordStatusEnum.COMPLETE.getCode());
            PlanOperationRecord.setEndTime(new Date());
            PlanOperationRecord record = planOperationRecordDao.save(PlanOperationRecord);
            Optional<PlanDetail> optionalPlanDetail = planDetailDao.findById(PlanOperationRecord.getPlanId());
            if (optionalPlanDetail.get() != null) {
                PlanDetail planDetail = optionalPlanDetail.get();
                planDetail.setStatus(ContingencyPlanStatusEnum.AVAILABLE.getCode());
                PlanDetail detail = planDetailDao.save(planDetail);
            }
            //数字预案业务屏web端发送消息
            this.sendweb("recordarea", paramObj, result);
        }

        // 结束预案，更新预案信息表结束时间
        contingencyInstanceInfoService.updateEndTimeById(batchNo);

        this.sendcmd("message", paramObj, result);
        redisTemplate.delete("contingencyRo");
        // 预案结束清空redis
        planStepService.initPlanStep();
        planStepService.initPlanTask();
    }


    @RuleMethod(methodLabel = "自动执行步骤", project = "换流站消防专项预案")
    public void autoExecute(@MethodParam(paramLabel = "动作名称") String actionName, @MethodParam(paramLabel = "步骤编号") String stepCode, @MethodParam(paramLabel = "按钮编码") String buttonCode, @MethodParam(paramLabel = "步骤状态") String stepState, @MethodParam(paramLabel = "预案对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            ContingencyPlanInstance contingencyPlanInstance = iContingencyInstance.createInstanceRecord(contingencyRo.getBatchNo(), actionName, "DEFAULT", "", "OPERATE", "");

            Toke toke = remoteSecurityService.getServerToken();
            RequestContext.setToken(toke.getToke());
            RequestContext.setProduct(toke.getProduct());
            try {
                iContingencyInstance.setButtonExecuted(contingencyRo.getBatchNo(), contingencyPlanInstance.getId(), buttonCode, "CONFIRM", null);

                iContingencyInstance.fire(contingencyRo.getBatchNo(), stepCode, contingencyPlanInstance.getId(), buttonCode, "CONFIRM", stepState);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @RuleMethod(methodLabel = "添加步骤执行", project = "换流站消防专项预案")
    public void addExecute(@MethodParam(paramLabel = "步骤编号") String stepCode, @MethodParam(paramLabel = "按钮编码") String buttonCode, @MethodParam(paramLabel = "设备数据") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();
            Map<String, Object> content = new HashMap<>();

            content.put("stepCode", stepCode);
            content.put("buttonCode", buttonCode);

            DeviceRo ro = (DeviceRo) paramObj;
            Map<String, Object> equipemtnPoints = pointCache.get(ro.getEquipmentId());
            if (ObjectUtils.isEmpty(equipemtnPoints)) {
                equipemtnPoints = new HashMap<>();
            }
            equipemtnPoints.put(stepCode + "-" + buttonCode, content);
            tempmap1.put("type", "buttonCache");
            tempmap1.put("content", equipemtnPoints.values());
            result.add(tempmap1);
            this.sendcmd("message", ro, result);
        }
    }

    @RuleMethod(methodLabel = "清除步骤执行", project = "换流站消防专项预案")
    public void clearExecute(@MethodParam(paramLabel = "步骤编号") String stepCode, @MethodParam(paramLabel = "按钮编码") String buttonCode, @MethodParam(paramLabel = "重点设备ID") String fireEquipmentId, @MethodParam(paramLabel = "步骤状态") String stepState, @MethodParam(paramLabel = "按钮状态") String buttonState, @MethodParam(paramLabel = "按钮json字符串") String buttonJson, @MethodParam(paramLabel = "步骤名称") String stepName) throws Exception {
        SafteyPlanResult result = new SafteyPlanResult();
        Map<String, Object> tempmap1 = new HashMap<>();
        Map<String, Object> content = new HashMap<>();

        content.put("stepCode", stepCode);
        content.put("buttonCode", buttonCode);
        if (ObjectUtils.isEmpty(fireEquipmentId)) {
            return;
        }
        String batchNo = planDetailMapper.queryBatchNoByFireEquipmentId(fireEquipmentId);
        if (ObjectUtils.isEmpty(batchNo)) {
            return;
        }
        content.put("batchNo", batchNo);

        tempmap1.put("type", "buttonCache");
        tempmap1.put("content", content);
        result.add(tempmap1);
        String instanceId = iContingencyInstance.getInstanceIdByBatchNOAndCategory("OPERATE", stepName, batchNo);
        String json = iPlanStepService.getPlanStep();
        List<PlanStepJsonVO> res = JSONObject.parseArray(json, PlanStepJsonVO.class);
        PlanStepJsonVO vo = res.stream().filter(x -> x.getStepCode().equals(stepCode)).collect(Collectors.toList()).get(0);
        Object obj = equipmentFireEquipmentService.automaticExecutePoint(vo.getIndex());
        if (Boolean.TRUE == obj) {
            iContingencyInstance.fire(batchNo, stepCode, buttonJson, instanceId,
                    buttonCode, buttonState, stepState, "true", "true", getToken(),
                    getProduct(), getAppKey(), "系统执行自动步骤");
        }
        this.sendcmd("message", result);
    }

    @RuleMethod(methodLabel = "同步自动执行步骤", project = "换流站消防专项预案")
    public void sendExecute(@MethodParam(paramLabel = "预案对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();
            Map<String, Object> equipemtnPoints = pointCache.get(contingencyRo.getEquipmentId());
            tempmap1.put("type", "buttonCache");
            tempmap1.put("content", ObjectUtils.isEmpty(equipemtnPoints) ? new ArrayList<>() : equipemtnPoints.values());
            result.add(tempmap1);

            this.sendcmd("message", paramObj, result);
        }
    }

    @RuleMethod(methodLabel = "自动执行动作V2", project = "换流站消防专项预案")
    public void autoExecuteActionV2(@MethodParam(paramLabel = "步骤编码") String stepCode, @MethodParam(paramLabel = "按钮编码") String buttonCode, @MethodParam(paramLabel = "按钮状态") String confirm, @MethodParam(paramLabel = "步骤状态") String stepState, @MethodParam(paramLabel = "动作名称") String actionName, @MethodParam(paramLabel = "图标") String icon, @MethodParam(paramLabel = "提示信息") String tips, @MethodParam(paramLabel = "按钮json字符串") String buttonJson, @MethodParam(paramLabel = "预案对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        long startTime = System.currentTimeMillis();
        if (!findByBatchNoAndStatus(batchNo)) {
            ContingencyPlanInstance contingencyPlanInstance = getContingencyPlan(contingencyRo.getBatchNo(), actionName, icon, tips, buttonJson);
            String contingencyPlanId = contingencyPlanInstance.getId();
            try {
                contingencyPlanInstance.setRoleCode(planStepService.getPlanStepRoleCodeByButtonCode(buttonCode));
                contingencyPlanInstanceRepository.save(contingencyPlanInstance);
                contingencyInstance.fire(contingencyRo.getBatchNo(), stepCode, buttonJson, contingencyPlanId, buttonCode, confirm, stepState, "true", "true", getToken(), getProduct(), getAppKey(), null);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        long endTime = System.currentTimeMillis();
        log.warn("自动执行动作V2耗时+++++++++++++++++++++++++++++++++" + (endTime - startTime) / 1000 + "秒" + ", 当前步骤编号: " + stepCode);
    }

    public void sendcmd(String msgType, SafteyPlanResult result) {
        Constructor<?> constructor;
        try {
            constructor = Class.forName(PACKAGEURL + result.getClass().getSimpleName() + "Message").getConstructor(ActionResult.class);
            AbstractActionResultMessage<?> action = (AbstractActionResultMessage<?>) constructor.newInstance(result);
            if ("mqtt".equals(pushType.toLowerCase(Locale.ENGLISH))) {
                ToipResponse toipResponse = action.buildResponse(msgType, null, result.toJson());
                String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
                log.info(String.format("mqtt[%s]:【 %s 】", topic, toipResponse.toJsonStr()));
                webMqttComponent.publish(topic, toipResponse.toJsonStr());

                ContingencyEvent event = new ContingencyEvent(this);
                event.setMsgBody(toipResponse.toJsonStr());
                event.setTopic(topic);
                event.setMsgType(msgType);
                contingencyLogPublisher.publish(event);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopSnapshop(ContingencyRo contingencyRo) {
        if (RuleRunigSnapshotServiceImpl.getReplayBatchNo() != null && !RuleRunigSnapshotServiceImpl.getReplayBatchNo().equals(contingencyRo.getBatchNo()))
            RuleRunigSnapshotServiceImpl.setReplayBatchNoToNull();
    }

    @Override
    public void intreeuptPlan(String batchNo) {
        ContingencyRo contingencyRo = new ContingencyRo();
        contingencyRo.setBatchNo(batchNo);
        SafteyPlanResult result = new SafteyPlanResult();
        Map<String, Object> tempmap1 = new HashMap<>();

        tempmap1.put("type", "event");
        ArrayList records = new ArrayList<>();
        HashMap map = new HashMap();
        map.put("time", sdf.format(new Date()));
        map.put("stepName", "应急处置中断");
        records.add(map);
        tempmap1.put("content", records);
        //数字预案结束状态
        tempmap1.put("status", PlanRecordStatusEnum.INTERRUPT.getCode());
        result.add(tempmap1);
        //数字预案业务屏web端发送消息
        this.sendweb("recordarea", contingencyRo, result);
        updateNumberPlan(batchNo);
        // 应急处置中断，初始化planStep，json数据；更新预案结束时间
        planStepService.initPlanStep();
        // 更新预案结束时间
        contingencyInstanceInfoService.updateEndTimeById(batchNo);
    }

    /**
     * 修改数字预案状态
     */
    public void updateNumberPlan(String batchNo) {
        //  结束预案 更新预案记录表,预案状态
        PlanOperationRecord PlanOperationRecord = planOperationRecordDao.findByBatchNo(batchNo);
        if (PlanOperationRecord != null) {
            PlanOperationRecord.setStatus(PlanRecordStatusEnum.INTERRUPT.getCode());
            PlanOperationRecord.setEndTime(new Date());
            PlanOperationRecord record = planOperationRecordDao.save(PlanOperationRecord);
            Optional<PlanDetail> optionalPlanDetail = planDetailDao.findById(PlanOperationRecord.getPlanId());
            if (optionalPlanDetail.get() != null) {
                PlanDetail planDetail = optionalPlanDetail.get();
                planDetail.setStatus(ContingencyPlanStatusEnum.AVAILABLE.getCode());
                PlanDetail detail = planDetailDao.save(planDetail);
            }
        }
    }

    /**
     * 通过batchNo获取预案的状态
     *
     * @param batchNo
     * @return
     */
    private Boolean findByBatchNoAndStatus(String batchNo) {
        return CollectionUtils.isEmpty(planOperationRecordDao.findByBatchNoAndStatus(batchNo, 0));
    }

    /**
     * 任务动作保存
     * @param taskName 任务名称
     *
     */
    @RuleMethod(methodLabel = "任务动作保存", project = "换流站消防专项预案")
    @Transactional
    public void saveTaskInfo(@MethodParam(paramLabel = "任务名称") String taskName, @MethodParam(paramLabel = "角色编码") String roleCode, @MethodParam(paramLabel = "任务编号") Integer taskNum, @MethodParam(paramLabel = "步骤编码") String stepCode, @MethodParam(paramLabel = "按钮json字符串") String buttonJson, @MethodParam(paramLabel = "预案对象") Object paramObj) {
        ContingencyRo contingencyRo = (ContingencyRo) paramObj;
        String batchNo = contingencyRo.getBatchNo();
        if (!findByBatchNoAndStatus(batchNo)) {
            String instanceId = iContingencyInstance.getInstanceIdByBatchNOAndCategory("TASKOPERATE", taskName, batchNo);
            if (!StringUtils.isEmpty(instanceId)) {
                return;
            }
            emergencyTaskService.saveTask("-2", batchNo);
        }
    }
}
