package com.yeejoin.amos.fas.business.action;

import com.yeejoin.amos.component.rule.MethodParam;
import com.yeejoin.amos.component.rule.RuleActionBean;
import com.yeejoin.amos.component.rule.RuleMethod;
import com.yeejoin.amos.fas.business.action.mq.WebMqttComponent;
import com.yeejoin.amos.fas.business.action.result.ActionResult;
import com.yeejoin.amos.fas.business.action.result.BubbleTipResult;
import com.yeejoin.amos.fas.business.action.result.message.AbstractActionResultMessage;
import com.yeejoin.amos.fas.business.service.model.ToipResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
/**
 *
 * <pre>
 * 风险态势图动作
 * </pre>
 *
 * @author amos
 * @version $Id: RiskSituationAction.java, v 0.1 2019年5月16日 下午5:26:27 amos Exp $
 */
@Component
@RuleActionBean(beanLabel = "动态预案")
public class RiskSituationAction implements CustomerAction
{
	private static String PACKAGEURL = "com.yeejoin.amos.fas.business.action.result.message.";


    @Autowired
    private WebMqttComponent webMqttComponent;

    @Value("${auto-sys.push.type}")
    private String pushType;
    @Value("${spring.application.name}")
    private String serviceName;

    @Value("${station.name}")
    private String stationName;

	@RuleMethod(methodLabel = "气泡提示", project = "换流站消防专项预案")
	public void sendBubbleTip(@MethodParam(paramLabel = "bizobj对象") Object bizobj,
			@MethodParam(paramLabel = "是否显示名称") Boolean showInfo,
			@MethodParam(paramLabel = "标题") String title)
	{
		BubbleTipResult result = new BubbleTipResult();
		Map<String, Object> tempmap1 = new HashMap<>();
		tempmap1.put("bizobj", bizobj);
		result.add(tempmap1);
		//是否显示气泡
		Map<String, Object> tempmap2 = new HashMap<>();
		tempmap2.put("showInfo", showInfo);
		result.add(tempmap2);
		//显示title提示
		Map<String, Object> tempmap3 = new HashMap<>();
		tempmap3.put("title", title);
		result.add(tempmap3);

		Constructor<?> constructor;
		try
		{
			constructor = Class.forName(
					PACKAGEURL + result.getClass().getSimpleName() + "Message")
					.getConstructor(ActionResult.class);
			 AbstractActionResultMessage<?> action = (AbstractActionResultMessage<?>) constructor.newInstance(result);
			String msgType = "bubbleTip";
			if ("mqtt".equals(pushType.toLowerCase(Locale.ENGLISH))) {
            	ToipResponse toipResponse = action.buildResponse(msgType, bizobj, result);
            	String topic = String.format("/%s/%s/%s", serviceName, stationName,"rule");
                webMqttComponent.publish(topic, toipResponse.toJsonStr());
            } else {
            	Object obj = action.execute(msgType, bizobj);
            }
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	@RuleMethod(methodLabel = "区域颜色改变", project = "换流站消防专项预案")
	public void regionChange(@MethodParam(paramLabel = "bizobj对象") Object bizobj, @MethodParam(paramLabel = "颜色") String colour)
	{
		BubbleTipResult result = new BubbleTipResult();
		Map<String, Object> tempmap1 = new HashMap<>();
		tempmap1.put("bizobj", bizobj);
		result.add(tempmap1);
		//更改颜色
		Map<String, Object> tempmap2 = new HashMap<>();
		tempmap2.put("colour", colour);
		result.add(tempmap2);

		Constructor<?> constructor;
		try
		{
			constructor = Class.forName(
					PACKAGEURL + result.getClass().getSimpleName() + "Message")
					.getConstructor(ActionResult.class);
			 AbstractActionResultMessage<?> action = (AbstractActionResultMessage<?>) constructor.newInstance(result);
				String msgType = "changeColor";
				if ("mqtt".equals(pushType.toLowerCase(Locale.ENGLISH))) {
	            	ToipResponse toipResponse = action.buildResponse(msgType, bizobj, result);
	                webMqttComponent.publish("", toipResponse.toJsonStr());
	            } else {
	            	action.execute(msgType, bizobj);
	            }
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}


	//@ExposeAction(value = "区域闪烁",snapshot = false)
	@RuleMethod(methodLabel = "区域闪烁", project = "换流站消防专项预案")
	public void regionFlicker(@MethodParam(paramLabel = "bizobj对象")  Object bizobj, @MethodParam(paramLabel = "闪烁频率")  Integer frequency)
	{
		BubbleTipResult result = new BubbleTipResult();
		Map<String, Object> tempmap1 = new HashMap<>();
		result.add(tempmap1);
		//更改颜色
		Map<String, Object> tempmap2 = new HashMap<>();
		tempmap2.put("frequency", frequency);
		result.add(tempmap2);

		Constructor<?> constructor;
		try
		{
			constructor = Class.forName(
					PACKAGEURL + result.getClass().getSimpleName() + "Message")
					.getConstructor(ActionResult.class);
			 AbstractActionResultMessage<?> action = (AbstractActionResultMessage<?>) constructor.newInstance(result);
			String msgType = "message";
			if ("mqtt".equals(pushType.toLowerCase(Locale.ENGLISH))) {
            	ToipResponse toipResponse = action.buildResponse(msgType, bizobj, result);
                webMqttComponent.publish("", toipResponse.toJsonStr());
            } else {
            	action.execute(msgType, null);
            }
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	@Override
	public void intreeuptPlan(String batchNo) {

	}
}
