package com.yeejoin.amos.fas.business.action.mq;

import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;

import javax.annotation.PostConstruct;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

@Component
public class WebMqttComponent {
	@Autowired
    private EmqKeeper emqKeeper;

	BlockingQueue<Message> queue = new LinkedBlockingQueue<Message>();
	ExecutorService service = null;

	@PostConstruct
	public void init() {
		service = Executors.newSingleThreadExecutor();
		service.execute(new Runnable()  {
			@Override
			public void run() {
				while (true) {
					try {
						Message msg = queue.take();
						emqKeeper.getMqttClient().publish(msg.getTopic(), msg.getJsonStr().getBytes(), 0, false);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		});
	}
	
	public void publish(String topic, String jsonStr) {
		Message msg = new Message(topic, jsonStr);
		queue.add(msg);
	}

	class Message {
		private String topic;
		private String jsonStr;

		public Message(String topic, String jsonStr) {
			this.topic = topic;
			this.jsonStr = jsonStr;
		}

		public String getTopic() {
			return topic;
		}

		public void setTopic(String topic) {
			this.topic = topic;
		}

		public String getJsonStr() {
			return jsonStr;
		}

		public void setJsonStr(String jsonStr) {
			this.jsonStr = jsonStr;
		}
	}
}
