package com.yeejoin.amos.fas.business.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.fas.business.dao.mapper.EmergencyTaskMapper;
import com.yeejoin.amos.fas.business.dao.mapper.EmergencyTaskRoleMapper;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil2;
import com.yeejoin.amos.fas.core.util.ResponseModel;
import com.yeejoin.amos.fas.dao.entity.EmergencyTaskRole;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/api/emergencyTaskRole")
@Api(tags = "应急任务角色API")
public class EmergencyTaskRoleController extends BaseController {

    @Autowired
    private EmergencyTaskRoleMapper emergencyTaskRoleMapper;

    @Autowired
    private EmergencyTaskMapper emergencyTaskMapper;

    /**
     * 创建数字预案
     */
    @Permission
    @ApiOperation(value = "新增", notes = "新增")
    @PostMapping(value = "/save", produces = "application/json;charset=UTF-8")
    public ResponseModel save(@RequestBody EmergencyTaskRole emergencyTaskRole) {
        if (null == emergencyTaskRole) {
            return CommonResponseUtil2.failure("参数有误");
        }
        int i = emergencyTaskRoleMapper.countByCode(emergencyTaskRole.getCode());
        if (i > 0) {
            return CommonResponseUtil2.failure("角色编码已存在");
        }
        AgencyUserModel curUser = getUserInfo();
        emergencyTaskRole.setCreater(curUser.getUserId());
        ReginParams reginParams = getSelectedOrgInfo();
        emergencyTaskRole.setBizOrgCode(getOrgCode(reginParams));
        emergencyTaskRole.setBizOrgName(!ObjectUtils.isEmpty(reginParams) && !ObjectUtils.isEmpty(reginParams.getCompany()) ? reginParams.getCompany().getCompanyName() : "");
        emergencyTaskRole.setCreateDate(new Date());
        emergencyTaskRoleMapper.save(emergencyTaskRole);
        return CommonResponseUtil2.success();
    }

    /**
     * 修改数字预案
     */
    @Permission
    @ApiOperation(value = "编辑", notes = "编辑")
    @PutMapping(value = "/update", produces = "application/json;charset=UTF-8")
    public ResponseModel update(@RequestBody EmergencyTaskRole emergencyTaskRole) {
        if (null == emergencyTaskRole) {
            return CommonResponseUtil2.failure("参数有误");
        }
        emergencyTaskRoleMapper.updateById(emergencyTaskRole);
        return CommonResponseUtil2.success();
    }


    @Permission
    @ApiOperation(value = "详情", notes = "详情")
    @GetMapping(value = "/getById", produces = "application/json;charset=UTF-8")
    public ResponseModel getById(@RequestParam(value = "id") Long id) {
        EmergencyTaskRole emergencyTaskRole = emergencyTaskRoleMapper.selectById(id);
        return CommonResponseUtil2.success(emergencyTaskRole);
    }

    @Permission
    @ApiOperation(value = "根据角色编码查信息", notes = "根据角色编码查信息")
    @GetMapping(value = "/getByCode", produces = "application/json;charset=UTF-8")
    public ResponseModel getByCode(@RequestParam(value = "code") String code) {
        EmergencyTaskRole emergencyTaskRole = emergencyTaskRoleMapper.selectByCode(code);
        return CommonResponseUtil2.success(emergencyTaskRole);
    }

    @Permission
    @ApiOperation(value = "分页查询", notes = "分页查询")
    @PostMapping(value = "/getInfoByPage")
    public ResponseModel<Page<EmergencyTaskRole>> getInfoByPage(@RequestBody EmergencyTaskRole emergencyTaskRole,
                                                                @RequestParam Integer pageNum,
                                                                @RequestParam Integer size) {
        Page<EmergencyTaskRole> emergencyTaskRolePage = new Page<>(pageNum, size);
        int infoCount = emergencyTaskRoleMapper.getInfoCount(emergencyTaskRole);
        emergencyTaskRolePage.setTotal(infoCount);
        List<EmergencyTaskRole> infoByPage = emergencyTaskRoleMapper.getInfoByPage((pageNum - 1) * size, size, emergencyTaskRole);
        emergencyTaskRolePage.setRecords(infoByPage);
        return CommonResponseUtil2.success(emergencyTaskRolePage);
    }


    @Permission
    @ApiOperation(value = "根据ID删除数据", notes = "根据ID删除数据")
    @DeleteMapping(value = "/deleteById", produces = "application/json;charset=UTF-8")
    public ResponseModel deleteById(@RequestParam(value = "id") Long id) {
        int total = emergencyTaskMapper.getEmergencyTaskCount(id, null);
        if (total > 0) {
            return CommonResponseUtil2.failure("已有应急任务，不能删除！");
        }
        emergencyTaskRoleMapper.deleteRelationByRoleId(id);
        emergencyTaskRoleMapper.deleteById(id);
        return CommonResponseUtil2.success();
    }

    @Permission
    @ApiOperation(value = "下拉列表", notes = "下拉列表")
    @GetMapping(value = "/getList")
    public ResponseModel<List<EmergencyTaskRole>> getList() {
        List<EmergencyTaskRole> emergencyTaskRoles = emergencyTaskRoleMapper.selectList();
        return CommonResponseUtil2.success(emergencyTaskRoles);
    }
}
