package com.yeejoin.amos.fas.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.fas.business.action.model.ContingencyRo;
import com.yeejoin.amos.fas.business.action.mq.WebMqttComponent;
import com.yeejoin.amos.fas.business.dao.mapper.EmergencyTaskMapper;
import com.yeejoin.amos.fas.business.dao.mapper.EmergencyTaskRoleMapper;
import com.yeejoin.amos.fas.business.dao.mapper.PlanOperationRecordMapper;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyPlanInstanceRepository;
import com.yeejoin.amos.fas.business.dao.repository.IPlanOperationRecordDao;
import com.yeejoin.amos.fas.business.service.intfc.IContingencyInstance;
import com.yeejoin.amos.fas.business.service.intfc.IEmergencyTaskService;
import com.yeejoin.amos.fas.business.service.intfc.IPlanStepService;
import com.yeejoin.amos.fas.business.service.intfc.IPlanVisual3dService;
import com.yeejoin.amos.fas.business.vo.ContingencyPlanInstanceVO;
import com.yeejoin.amos.fas.business.vo.EmergencyTaskContentVo;
import com.yeejoin.amos.fas.business.vo.MessageVO;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.StringUtil;
import com.yeejoin.amos.fas.dao.entity.*;
import com.yeejoin.amos.fas.interceptors.PermissionInterceptorContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Service
public class EmergencyTaskServiceImpl implements IEmergencyTaskService {

    @Autowired
    private EmergencyTaskMapper emergencyTaskMapper;

    @Autowired
    private IContingencyInstance iContingencyInstance;

    @Autowired
    private IPlanOperationRecordDao planOperationRecordDao;

    @Autowired
    private IContingencyPlanInstanceRepository contingencyPlanInstanceRepository;

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private IPlanVisual3dService planVisual3dService;

    @Autowired
    private IPlanStepService planStepService;

    @Autowired
    private WebMqttComponent webMqttComponent;

    @Autowired
    private PlanOperationRecordMapper planOperationRecordMapper;

    @Autowired
    private EmergencyTaskRoleMapper emergencyTaskRoleMapper;

    @Value("${spring.application.name}")
    private String serviceName;

    @Value("${station.name}")
    private String stationName;
    @Value("${auth-key-auth-enabled:}")
    private String authKey;

    String taskJson = "{\"type\":\"button\",\"operate\":[{\"code\":\"STOP_OIL_CONSERVATOR_DRAIN\",\"icon\":\"yellow\",\"state\":\"wait\",\"title\":\"已执行\",\"confirm\":false,\"content\":\"_content\",\"delayed\":[0],\"stepState\":\"A\",\"requestUrl\":\"/fireAutoSys/api/timeline/click\"}],\"stepCode\":\"_stepCode\"}";

    @Override
    public Page<EmergencyTaskContent> list(Long obligationId, String planType, CommonPageable pageable) {
        int total = emergencyTaskMapper.getEmergencyTaskCount(obligationId, planType);
        List<EmergencyTaskContent> emergencyTaskList = emergencyTaskMapper.getEmergencyTaskList(obligationId, pageable.getOffset(), pageable.getPageSize(), planType);
        org.springframework.data.domain.Page<EmergencyTaskContent> result = new PageImpl<>(emergencyTaskList, pageable, total);
        return result;

    }

    @Override
    public List<EmergencyRelationTree> treeList() {

        return emergencyTaskMapper.treeList();
    }

    @Override
    public void deleteTreeNode(Long obligationId, Long personId) {
        emergencyTaskMapper.deleteTreeNode(obligationId, personId);
    }

    @Override
    public void save(EmergencyRelation emergencyRelation) {
        emergencyTaskMapper.save(emergencyRelation);
    }

    @Override
    public void saveTaskConfig(EmergencyTaskContent emergencyTaskContent) {
            List<String> roleList = emergencyTaskContent.getRoleCodeList();
        for (String role : roleList
             ) {
            String json = taskJson.replace("_content", emergencyTaskContent.getContent()).replace("_stepCode", emergencyTaskContent.getStepCode());
            emergencyTaskContent.setButtonJson(json);
            EmergencyTaskRole emergencyTaskRole = emergencyTaskRoleMapper.selectById(Long.valueOf(role));
            emergencyTaskContent.setRoleCode(emergencyTaskRole.getCode());
            emergencyTaskContent.setObligationName(emergencyTaskRole.getName());
            if("1".equals(emergencyTaskContent.getIsMustString())) {
                emergencyTaskContent.setMust(true);
            } else {
                emergencyTaskContent.setMust(false);
            }
            emergencyTaskContent.setObligationId(emergencyTaskRole.getId());
            emergencyTaskMapper.saveTaskConfig(emergencyTaskContent);
        }
    }

    @Override
    public String getRolesByUserId(String userId) {
        // 权限处理
        PermissionInterceptorContext.setDataAuthRule(authKey);
        List<String> list = emergencyTaskMapper.roleCodes(userId);
        String roleCodes = String.join(",", list);
        return roleCodes;
    }

    @Override
    public String getRolesNameByUserId(String userId) {
        List<String> list = emergencyTaskMapper.roleNames(userId);
        String roleNames = String.join(",", list);
        return roleNames;
    }

    @Override
    public List<Long> getPersonIds(Long obligationId) {
        return emergencyTaskMapper.getPersonIds(obligationId);
    }

    @Async
    @Transactional
    @Override
    public void saveTask(String stepCode, String batchId) {
        String planType = null;
        if (redisTemplate.hasKey("planType")) {
            planType = redisTemplate.boundValueOps("planType").get(0, -1);
        }
        List<EmergencyTaskContentVo> list = emergencyTaskMapper.getContentList(stepCode, planType);
        if (0 < list.size()) {
            String batchNo = StringUtil.isNotEmpty(batchId) ? batchId : planOperationRecordMapper.getLastBatchNo();
            if (!findByBatchNoAndStatus(batchNo)) {
                for (EmergencyTaskContentVo vo : list) {
                    String taskName = vo.getContent();
                    String roleCode = vo.getRoleCode();
                    Integer taskNum = Integer.valueOf(vo.getTaskNum());
                    String buttonJson = vo.getButtonJson();
                    String instanceId = iContingencyInstance.getInstanceIdByBatchNOAndCategory("TASKOPERATE", taskName, batchNo);
                    if (!StringUtils.isEmpty(instanceId)) {
                        return;
                    }
                    ContingencyPlanInstance contingencyPlanInstance = new ContingencyPlanInstance();
                    contingencyPlanInstance.setBatchNo(batchNo);
                    contingencyPlanInstance.setRecordType("TASKOPERATE");
                    contingencyPlanInstance.setRoleCode(roleCode);
                    contingencyPlanInstance.setCategory(taskName);
                    contingencyPlanInstance.setCreateDate(new Date());
                    contingencyPlanInstance.setTaskSort(taskNum);
                    contingencyPlanInstance.setStepCode(stepCode);
                    contingencyPlanInstance.setContent(buttonJson);
                    contingencyPlanInstanceRepository.saveAndFlush(contingencyPlanInstance);

                    if ("0".equals(stepCode)) {
                        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
                            @Override
                            public void afterCommit() {
                                String planStep = "";
                                if (redisTemplate.hasKey("planStep")) {
                                    planStep = Objects.requireNonNull(redisTemplate.opsForValue().get("planStep")).toString();
                                } else {
                                    planStep = planStepService.getPlanStep();
                                }
                                JSONArray objects = JSON.parseArray(planStep);
                                String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
                                Map<String, Object> result = new HashMap<>();
                                result.put("contingency", new ContingencyRo());
                                result.put("msgContext", Collections.EMPTY_MAP);
                                result.put("msgType", "getStepList");
                                result.put("planStep", objects);
                                String planTask = "";
                                if (redisTemplate.hasKey("planTask")) {
                                    planTask = Objects.requireNonNull(redisTemplate.opsForValue().get("planTask")).toString();
                                } else {
                                    List<ContingencyPlanInstanceVO> lists = planVisual3dService.getTaskActionList(batchNo, 1);
                                    planTask = JSON.toJSONString(lists);
                                }
                                JSONArray taskObjects = JSON.parseArray(planTask);
                                result.put("planTask", taskObjects);
                                webMqttComponent.publish(topic, JSON.toJSONString(result));
                            }
                        });
                    }

                    MessageVO messageVO = new MessageVO();
                    messageVO.setTitle("应急处置事项提醒");
                    messageVO.setBody("【" + taskName + "】" + DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
                    messageVO.setMsgType("emergencyPlan");
                    messageVO.setCategory(1);
                    messageVO.setIsSendApp(true);
                    messageVO.setIsSendWeb(true);
                    messageVO.setRelationId(batchNo);
                    planVisual3dService.sendMessage(roleCode, messageVO);
                }
            }
        }
    }

    private Boolean findByBatchNoAndStatus(String batchNo) {
        return CollectionUtils.isEmpty(planOperationRecordDao.findByBatchNoAndStatus(batchNo, 0));
    }

    @Override
    public List<EmergencyTaskContentVo> getMustTaskList(String stepCode, String planType) {
        // 权限处理
        PermissionInterceptorContext.setDataAuthRule(authKey);
        return emergencyTaskMapper.getMustTaskList(stepCode, planType);
    }
}
