package com.yeejoin.amos.fas.business.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.fas.business.dao.mapper.*;
import com.yeejoin.amos.fas.business.dao.repository.IEquipmentDao;
import com.yeejoin.amos.fas.business.dao.repository.IEquipmentFireEquipmentDao;
import com.yeejoin.amos.fas.business.dao.repository.IPlanMessageDao;
import com.yeejoin.amos.fas.business.service.intfc.EquipmentSpecificIndexService;
import com.yeejoin.amos.fas.business.service.intfc.IEquipmentFireEquipmentService;
import com.yeejoin.amos.fas.business.service.intfc.IPlanStepService;
import com.yeejoin.amos.fas.business.vo.ConditionVO;
import com.yeejoin.amos.fas.business.vo.PlanStepJsonVO;
import com.yeejoin.amos.fas.common.enums.SqlKeyWordEnum;
import com.yeejoin.amos.fas.dao.entity.EquipmentFireEquipment;
import com.yeejoin.amos.fas.dao.entity.PlanMessage;
import com.yeejoin.amos.fas.interceptors.PermissionInterceptorContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.Bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @ProjectName: YeeAmosFireAutoSysRoot
 * @Package: com.yeejoin.amos.fas.business.service.impl
 * @ClassName: EquipmentFireEquipmentServiceImpl
 * @Author: Jianqiang Gao
 * @Description:
 * @Date: 2022/5/20 14:40
 * @Version: 1.0
 */
@Service
public class EquipmentFireEquipmentServiceImpl implements IEquipmentFireEquipmentService {

    private final Logger log = LoggerFactory.getLogger(EquipmentFireEquipmentServiceImpl.class);

    private static final String TYPE = "or";
    private static final String VALUE = "true";
    @Value("${auth-key-auth-enabled:}")
    private String authKey;

    // 停运本极对端换流器
    private static final int stepIndex = 9;

    // 消防泵正常启动
    private static final int pumpStepIndex = 7;

    @Autowired
    private IEquipmentFireEquipmentService equipmentFireEquipmentService;

    @Autowired
    private EquipmentSpecificIndexService equipmentSpecificIndexService;

    @Autowired
    private IEquipmentFireEquipmentDao equipmentFireEquipmentDao;

    @Autowired
    PlanOperationRecordMapper planOperationRecordMapper;

    @Autowired
    PlanMessageMapper planMessageMapper;

    @Autowired
    IEquipmentDao iEquipmentDao;

    @Autowired
    IPlanMessageDao planMessageDao;

    @Autowired
    EquipmentSpecificIndexMapper equipmentSpecificIndexMapper;

    @Autowired
    private IPlanStepService iPlanStepService;


    @Override
    public List<EquipmentFireEquipment> findByEquipmentId(Long equipmentId) {
        return equipmentFireEquipmentDao.findAllByEquipmentId(equipmentId);
    }

    @Override
    public List<Long> findFireEquipmentIdsByEquipmentId(String[] equipmentIds) {
        return Optional.ofNullable(equipmentFireEquipmentDao.findFireEquipmentIdsByEquipmentId(equipmentIds)).orElse(new ArrayList<>());
    }

    @Override
    public List<EquipmentFireEquipment> findByEquipIdAndEquipCodeIn(Long equipmentId, String[] equipCodes) {
        return equipmentFireEquipmentDao.findByEquipIdAndEquipCodeIn(equipmentId, equipCodes);
    }

    @Override
    public List<EquipmentFireEquipment> findByEquipIdAndEquipSpeCodeIn(Long equipmentId, String[] equipSpeCodes) {
        return equipmentFireEquipmentDao.findByEquipIdAndEquipSpeCodeIn(equipmentId, equipSpeCodes);
    }

    @Override
    public Object automaticExecute(String equipmentId, String equipCode, String equipSpeCode, String type, String indexKeys, String value) {
        Map<String, Object> map = null;

        if(StringUtils.isBlank(equipCode)){
        	return false;
        }
        if (StringUtils.isBlank(type)) {
            type = TYPE;
        }
        if (StringUtils.isBlank(value)) {
            value = VALUE;
        }
        if (StringUtils.isNotBlank(equipmentId)) {
            //  1. 查询重点设备绑定的消防设备
            List<EquipmentFireEquipment> list = null;
            if (StringUtils.isBlank(equipSpeCode)) {
                if (StringUtils.isBlank(equipCode)) {
                    list = equipmentFireEquipmentService.findByEquipmentId(Long.parseLong(equipmentId));
                } else {
                    list = equipmentFireEquipmentService.findByEquipIdAndEquipCodeIn(Long.parseLong(equipmentId), equipCode.split(","));
                }
            } else {
                list = equipmentFireEquipmentService.findByEquipIdAndEquipSpeCodeIn(Long.parseLong(equipmentId), equipSpeCode.split(","));
            }
            if (!CollectionUtils.isEmpty(list)) {
                List<Long> equipSpecificIdList = list.stream().map(EquipmentFireEquipment::getFireEquipmentId).collect(Collectors.toList());
                //  2 获取消防设备满足条件的集合
                if (StringUtils.isNotBlank(indexKeys)) {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(equipSpecificIdList, null, null, indexKeys.split(","), value);
                } else {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(equipSpecificIdList, null, null, null, value);
                }
            }
        } else {
            //  不存在重点设备，直接查消防设备
            if (StringUtils.isNotBlank(equipSpeCode)) {
                if (StringUtils.isNotBlank(indexKeys)) {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(null, null, equipSpeCode.split(","), indexKeys.split(","), value);
                } else {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(null, null, equipSpeCode.split(","), null, value);
                }
            } else if (StringUtils.isNotBlank(equipCode)) {
                if (StringUtils.isNotBlank(indexKeys)) {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(null, equipCode.split(","), null, indexKeys.split(","), value);
                } else {
                    map = equipmentSpecificIndexService.countEquipIndexAndValueOfNum(null, equipCode.split(","), null, null, value);
                }
            }
        }
        if (null != map &&!CollectionUtils.isEmpty(map)) {
            Integer total = Integer.parseInt(map.getOrDefault("total", 0).toString());
            Integer count = Integer.parseInt(map.getOrDefault("count", 0).toString());
            if (SqlKeyWordEnum.AND.getKey().equalsIgnoreCase(type)) {
                return total.equals(count);
            } else if (SqlKeyWordEnum.OR.getKey().equalsIgnoreCase(type)) {
                return count != 0;
            }
        }
        return false;
    }

    @Override
    public Object automaticExecutePoint(Integer index) {
        if (ObjectUtils.isEmpty(index)) {
            return false;
        }
        String planStep = iPlanStepService.getPlanStep();
        List<PlanStepJsonVO> result = JSONObject.parseArray(planStep, PlanStepJsonVO.class);
        if (!CollectionUtils.isEmpty(result)) {
            // 权限处理
            PermissionInterceptorContext.setDataAuthRule(authKey);
            // 获取电力设备id及batchNo
            Map<String, Object> map = planOperationRecordMapper.getLatestFireEquipId();
            String fireEquipId = String.valueOf(map.get("fireEquipId"));
            List<Long> fireEquipments = new ArrayList<>();
            // 若是停运本极对端换流器，则需查出本极对应的电力设备列表，暂用电力设备名称过滤出本极电力设备，注意此处的电力设备按照标准有两极（极I，极II）
//            if (stepIndex == index) {
//                Optional<Equipment> equipment = iEquipmentDao.findById(Long.valueOf(fireEquipId));
//                if (equipment.get() != null) {
//                    String fireEquipNamePrefix = equipment.get().getName().substring(0, 2);
//                    List<String> fireEquipIdList = equipmentSpecificMapper.getFireEquipIdsByNamePrefix(fireEquipNamePrefix);
//                    String[] strings = fireEquipIdList.toArray(new String[fireEquipIdList.size()]);
//                    // 获取消防设备id列表
//                    fireEquipments = equipmentFireEquipmentService.findFireEquipmentIdsByEquipmentId(strings);
//                }
//            } else {
            String[] fireEquipIds = new String[]{fireEquipId};
            // 获取消防设备id列表
            fireEquipments = equipmentFireEquipmentService.findFireEquipmentIdsByEquipmentId(fireEquipIds);
//            }

            PlanStepJsonVO vo = result.stream().filter(x -> x.getIndex() == index).collect(Collectors.toList()).get(0);
            List<ConditionVO> list = vo.getCondition();
            if (!CollectionUtils.isEmpty(list)) {
                // 获取符合条件的报文条数
                int num = equipmentSpecificIndexMapper.countEquipIndexAndValueNum(list, fireEquipments, vo.getOutAndOr());

                // 获取符合自动执行的报文数据并存储
                List<PlanMessage> planMessages = equipmentSpecificIndexService.getEquipIndexAndValue(list, fireEquipments, vo.getOutAndOr());
                int resultSize = planMessages.size();
                if (0 < resultSize) {
                    List<PlanMessage> messages = planMessages.stream().map(x -> {
                        PlanMessage planMessage = new PlanMessage();
                        Bean.copyExistPropertis(x, planMessage);
                        planMessage.setBatchNo(String.valueOf(map.get("batchNo")));
                        planMessage.setStepCode(vo.getStepCode());
                        planMessage.setStepIndex(vo.getIndex());
                        return planMessage;
                    }).collect(Collectors.toList());
                    for (PlanMessage message : messages) {
                        // 权限处理
                        PermissionInterceptorContext.setDataAuthRule(authKey);
                        int count = planMessageMapper.getPlanMessageCount(String.valueOf(map.get("batchNo")), index, message.getIndexCreateTime());
                        if (0 <count) {
                            continue;
                        }
                        planMessageDao.save(message);
                    }
                }
//                if (pumpStepIndex == index) {
//                    return 0 < resultSize;
//                } else {
                return (0 < resultSize && num == resultSize);
//                }
            } else {
                return false;
            }
        }
        return false;
    }
}
