package com.yeejoin.amos.fas.config;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;

/**
 * @author keyong
 * @title: LogFilter
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2024/3/25 15:04
 */
public class LogFilter extends ClassicConverter {

    private static final List<String> LOG_VALID_LIST = Arrays.asList("%0d", "%0a", "%0A", "%0D", "\r", "\n");

    @Override
    public String convert(ILoggingEvent event) {
        if (event.getLoggerName().startsWith("com.yeejoin")) { //根据package启用规则
            return validLog(event.getFormattedMessage());
        } else {
            return event.getFormattedMessage();
        }
    }

    public static String validLog(String logs) {
        String normalize = Normalizer.normalize(logs, Normalizer.Form.NFKC);
        for (String str : LOG_VALID_LIST) {
            normalize = normalize.replace(str, "");
        }
        return normalize;
    }

}
