package com.yeejoin.amos.fas.core.threadpool;

import org.slf4j.Logger;

import com.yeejoin.amos.fas.business.constants.FasConstant;
import org.slf4j.LoggerFactory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 线程池
 */
public class AmosThreadPool {

    /**
     * 日志记录器
     */
    private static final Logger logger = LoggerFactory.getLogger(AmosThreadPool.class);

    private static volatile AmosThreadPool amosThreadPool = null;

    /**
     * 单例
     */
    private static AmosThreadPool instance;

    /**
     * 执行服务
     */
    private static ExecutorService executorService;

    /**
     * 获取单例
     *
     * @return
     */
    public static AmosThreadPool getInstance() {
        if (amosThreadPool == null) {
            synchronized (AmosThreadPool.class) {
                if (amosThreadPool == null) {
                    amosThreadPool = new AmosThreadPool();
                }
            }
        }
        return amosThreadPool;
    }

    static {
        executorService = Executors
                .newFixedThreadPool(FasConstant.AMOS_THREAD_NUM);
    }

    /**
     * 执行线程
     *
     * @param task
     */
    public void execute(Runnable task) {
        executorService.execute(task);
    }

}
