package com.yeejoin.amos.fas.interceptors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionInterceptorContext {
    private static final Logger logger = LoggerFactory.getLogger(PermissionInterceptorContext.class);

    private static ThreadLocal<PermissionInterceptorContextModel> requestContext = ThreadLocal.withInitial(PermissionInterceptorContextModel::new);

    private static PermissionInterceptorContextModel getPermissionInterceptorContext() {
        return requestContext.get();
    }

    public static String getDataAuthRule() {
        return getPermissionInterceptorContext().getDataAuthRule();
    }

    public static void setDataAuthRule(String dataAuthRule) {
        getPermissionInterceptorContext().setDataAuthRule(dataAuthRule);
    }

    public static void clean() {
        if (requestContext != null) {
            logger.info("PermissionInterceptorContext clean RestThreadLocal......Begin");
            requestContext.remove();
            logger.info("PermissionInterceptorContext clean RestThreadLocal......Done");
        }
    }

    public static void clean(String info) {
        if (requestContext != null) {
            logger.info("......" + info + "......PermissionInterceptorContext clean RestThreadLocal......Begin");
            requestContext.remove();
            logger.info("......" + info + "......PermissionInterceptorContext clean RestThreadLocal......Done");
        }
    }
}
