package com.yeejoin.amos;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.Collections;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.yeejoin.amos.fas.client.invoke.RsDataQueue;
import com.yeejoin.amos.fas.context.IotContext;
import com.yeejoin.amos.filter.CrossDomainFilter;

import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 *
 * <pre>
 * 服务启动类
 * </pre>
 *
 * @author amos
 * @version $Id: AmosOPStart.java, v 0.1 2018年11月26日 下午4:56:29 amos Exp $
 */
@EnableHystrix
@EnableScheduling
@SpringBootApplication(exclude={MybatisPlusAutoConfiguration.class})
@EnableTransactionManagement
@EnableConfigurationProperties
@EnableSwagger2
@ServletComponentScan
@EnableJpaAuditing
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@ComponentScan({ "org.typroject", "com.yeejoin.amos" })
@MapperScan(basePackages = { "com.yeejoin.amos.fas.business.dao.mapper","org.typroject.tyboot.*.*.face.orm.dao","com.yeejoin.amos.api.*.face.orm.dao" })
public class YeeAmosFireAutoSysStart implements ApplicationContextAware {

	private static final Logger log = LoggerFactory.getLogger(YeeAmosFireAutoSysStart.class);

	/**
	 * 启动amosop-server
	 *
	 * @param args
	 * @throws IOException
	 * @throws URISyntaxException
	 */
	public static void main(String[] args) {
		log.info("start Service..........");
		SpringApplication application = new SpringApplication(YeeAmosFireAutoSysStart.class);
		ConfigurableEnvironment environment = new StandardEnvironment();
		int randomClientId = new SecureRandom().nextInt(65536 - 1024) + 1024;
		environment.getPropertySources().addFirst(new MapPropertySource("securityRandomSource",
				Collections.singletonMap("security-random-int", randomClientId)));
		application.setEnvironment(environment);
		application.run();
		String appName = environment.getProperty("spring.application.name");
		log.info(
				"\n----------------------------------------------------------\n\t"
						+ "Application {} is running!\n"
						+ "----------------------------------------------------------\n"
				, appName
		);
	}

	/**
	 * 获取并缓存上下文
	 */
	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		// 缓存spring上下文
		IotContext.getInstance().setApplicationContext(applicationContext);
		RsDataQueue.getInstance().start();
	}

	/**
	 *
	 * <pre>
	 * 跨域处理的FilterBean
	 * </pre>
	 *
	 * @return
	 */
	@Bean
	public FilterRegistrationBean crossFilterRegistrationBean() {
		FilterRegistrationBean registrationBean = new FilterRegistrationBean();
		CrossDomainFilter crossDomainFilter = new CrossDomainFilter();
		registrationBean.setFilter(crossDomainFilter);
		// List<String> urlPatterns = new ArrayList<String>();
		// urlPatterns.add("/*");
		// registrationBean.setUrlPatterns(urlPatterns);
		registrationBean.setOrder(0);// 值小的Filter先执行
		return registrationBean;
	}
}