package com.yeejoin.amos.fas.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum RiskSourceLevelEum {
    
	level_1("1","1级"),
	level_2("2","2级"),
	level_3("3","3级"),
	level_4("4","4级"),
	level_5("5","5级");
	
	private String level;
	private String name;
	
	RiskSourceLevelEum(String level, String name) {
		this.level = level;
		this.name = name;
	}

	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public static List<Map<String,String>> getLevelEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (RiskSourceLevelEum c: RiskSourceLevelEum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("level", c.getLevel());
			nameList.add(map);
		}
		return nameList;
	}
	
	
}
