package com.yeejoin.amos.fas.business.bo;

import com.yeejoin.amos.fas.common.enums.TriggerRpnChangeTypeEum;
import com.yeejoin.amos.fas.core.util.DateUtil;

import java.math.BigDecimal;

/**
 * 手机消息推送内容
 */
public class JpushMsgContentBo {
    /**
     * 危险因素名称
     */
    private String fmeaName;
    /**
     * 触发类型
     */
    private String notifyType;
    /**
     * 巡检状态
     */
    private String checkStatus;
    /**
     * 执行日期
     */
    private String executeDate = DateUtil.getLongCurrentDate();
    /**
     * 执行人
     */
    private String execute;
    /**
     * 等级变化范围
     */
    private int levelIsChange;
    /**
     * 当前rpn
     */
    private BigDecimal rpn;
    /**
     *风险等级
     */
    private String level;

    /**
     *标题
     */
    private String subject;

    /**
     * 关联名称
     */
    private String relationName;

    /**
     * 是否需要发送
     */
    private Boolean isSend;

    public JpushMsgContentBo(String fmeaName, String notifyType){
        this.fmeaName = fmeaName;
        this.notifyType = notifyType;
        this.setSubject(notifyType);
    }

    public Boolean getSend() {
        return isSend;
    }

    private void setSubject(String notifyType){
        if(notifyType.equals(TriggerRpnChangeTypeEum.patrol.getCode())){
            //巡检
            this.subject = "风险预警";
            this.isSend = true;
        } else if(notifyType.equals(TriggerRpnChangeTypeEum.alarm.getCode())){
            //设备告警
            this.subject = "风险预警";
            this.isSend = true;
        } else if(notifyType.equals(TriggerRpnChangeTypeEum.alarmRecovery.getCode())){
            //告警恢复
            this.subject = "告警恢复";
            this.isSend = true;
        } else if(notifyType.equals(TriggerRpnChangeTypeEum.fmeaUpdate.getCode())){
            //风险评价
            this.subject = "风险评价";
            this.isSend = true;
        }
    }

    public String genMessage(){
        StringBuilder message = new StringBuilder();
        if(notifyType.equals(TriggerRpnChangeTypeEum.patrol.getCode())){
            //巡检
            message.append("执行人：").append(execute).append("\n");
            message.append("执行时间：").append(executeDate).append("\n");
            message.append("危险因素名称：").append(fmeaName).append("\n");
            message.append("描述：").append("当前风险值上升到").append(rpn).append("，风险等级").append(getLevelChangeType()).append(level).append("\n");
            message.append("触发原因：").append("关联巡检点").append(relationName).append("检查").append(checkStatus);
        } else if(notifyType.equals(TriggerRpnChangeTypeEum.alarm.getCode())){
            //设备告警
            message.append("执行时间：").append(executeDate).append("\n");
            message.append("危险因素名称：").append(fmeaName).append("\n");
            message.append("描述：").append("当前风险值上升到").append(rpn).append("，风险等级").append(getLevelChangeType()).append(level).append("\n");
            message.append("触发原因：").append("关联设备").append(relationName).append("指标项报警");
        } else if(notifyType.equals(TriggerRpnChangeTypeEum.alarmRecovery.getCode())){
            //告警恢复
            message.append(relationName).append("设备告警解除");
        } else if(notifyType.equals(TriggerRpnChangeTypeEum.fmeaUpdate.getCode())){
            //风险评价
            message.append("评价人：").append(execute).append("\n");;
            message.append("评价时间：").append(executeDate).append("\n");
            message.append("评价内容：").append(fmeaName).append("\n");
            message.append("评价等级：").append(level);
        }
        return message.toString();
    }

    private String getLevelChangeType(){
        String changeType = "";
        if(levelIsChange > 0){
            changeType = "上升到";
        }else if(levelIsChange == 0){
            changeType = "不变";
        } else {
            changeType = "下降到";
        }
        return changeType;
    }

    public String getExecute() {
        return execute;
    }

    public void setExecute(String execute) {
        this.execute = execute;
    }

    public int getLevelIsChange() {
        return levelIsChange;
    }

    public void setLevelIsChange(int levelIsChange) {
        this.levelIsChange = levelIsChange;
    }

    public BigDecimal getRpn() {
        return rpn;
    }

    public void setRpn(BigDecimal rpn) {
        this.rpn = rpn;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getRelationName() {
        return relationName;
    }

    public String getSubject() {
        return subject;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }
}
