package com.yeejoin.amos.fas.business.dao.repository;

import java.util.List;
import java.util.Optional;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.fas.dao.entity.Fmea;

@Repository("iFmeaDao")
public interface IFmeaDao extends BaseDao<Fmea, Long> {

	List<Fmea> findByRiskFactorsId(Long id);

	List<Fmea> findByRiskSourceId(Long id);

	/**
	 * 根据风险点ID删除fmea对象
	 * 
	 * @param riskSourceId
	 */
	@Modifying
	@Transactional
	@Query(value="delete from f_fmea where risk_source_id in (?1)", nativeQuery = true)
	void deleteByRiskSourceId(Long[] riskSourceId);

	/**
	 * 根据ID删除fmea对象
	 * 
	 * @param fmeaIds
	 */
	@Modifying
	@Transactional
	@Query(value="delete from f_fmea where id in (?1)", nativeQuery = true)
	void deleteById(Long[] fmeaIds);


	Optional<Fmea> findById(Long id);

	@Query(value = "SELECT count(1) FROM `f_fmea_point_inputitem` WHERE fmea_id in ?1", nativeQuery = true)
    int countAssociatedInputItemByIds(String[] ids);

	@Query(value = "SELECT count(1) FROM `f_fmea_equipment_point` WHERE fmea_id in ?1", nativeQuery = true)
	int countAssociatedEquipPointByIds(String[] ids);

	@Query(value = "select * from `f_fmea` where id in ?1",nativeQuery = true)
    List<Fmea> findAllByRiskSourceIds(List<Long> ids);
}
