package com.yeejoin.amos.fas.business.feign;

import java.util.HashMap;
import java.util.Map;

import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import com.yeejoin.amos.fas.business.util.Constants;



@Service("remoteWebSocketServer")
public class RemoteWebSocketServer {
	/*@Autowired
    private ApplicationConfig applicationConfig;*/
	
	@Value("${params.remoteWebsocketUrl}")
    private String remoteRuleUrl;
	
    private final RestTemplate restTemplate;

    private ObjectMapper objectMapper = new ObjectMapper();
    public RemoteWebSocketServer()
    {
        this.restTemplate = new RestTemplate();
    }
    
    
    public Object sendMessage(String path, String message) throws Exception
    {
        Map<String, String> map = new HashMap<String, String>();
        map.put("filter", null);
        map.put("message", message);
        map.put("path", path);
        //String url = applicationConfig.getParamValueStr("params.remoteWebsocketUrl");
        String url =remoteRuleUrl;
        
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType
                .parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity<Map<String, String>> formEntity = new HttpEntity<Map<String, String>>(map, headers);
        ResponseEntity responseEntity = restTemplate.exchange(url + "/generic/sendMessage",
                HttpMethod.POST, formEntity, String.class);

        responseEntity.getBody();
        Map commonResponse = objectMapper.readValue(responseEntity.getBody().toString(),Map.class);
        if (commonResponse != null && commonResponse.get("result").equals(Constants.RESULT_SUCCESS) )
        {
            return commonResponse.get("dataList");
        }
        return null;
    }
}
