package com.yeejoin.amos.fas.business.service.intfc;

import com.yeejoin.amos.fas.business.bo.BindRegionBo;
import com.yeejoin.amos.fas.business.bo.JpushMsgBo;
import com.yeejoin.amos.fas.business.param.AlarmParam;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.param.FmeaBindParam;
import com.yeejoin.amos.fas.business.service.model.ContingencyDeviceStatus;
import com.yeejoin.amos.fas.business.service.model.FireEquimentDataRo;
import com.yeejoin.amos.fas.business.service.model.ProtalDataRo;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.response.RegionTreeResponse;
import com.yeejoin.amos.fas.core.common.response.RiskSourceTreeResponse;
import com.yeejoin.amos.fas.dao.entity.FmeaEquipmentPoint;
import com.yeejoin.amos.fas.dao.entity.FmeaPointInputitem;
import com.yeejoin.amos.fas.dao.entity.RiskSource;
import org.springframework.data.domain.Page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IRiskSourceService {

    /**
     * 新增及维护风险点
     */
    RiskSource editRiskSource(HashMap<String, Object> map) throws Exception;

    /**
     * 删除风险点
     */
    void deleteRiskSource(Long[] riskSourceId) throws Exception;

    /**
     * 根据参数分页查询风险点信息
     */
    Page<HashMap<String, Object>> queryRiskSourceByPage(CommonPageInfoParam param);

    List<Map> queryForRegion();

    List<Map> queryRPNReport();

    /**
     * 上升率
     */
    Map queryForRiseUp() throws Exception;

    List<Map> queryForMatrix();

    /**
     * 获取所有风险点
     */
    List<RiskSourceTreeResponse> findRiskSourceTrees(String compCode);

    List<FmeaEquipmentPoint> bindFireEquiment(FmeaBindParam fmeaBindParam);

    List<FmeaPointInputitem> bindPointInputitem(FmeaBindParam fmeaBindParam);

    /**
     * 查询指定风险点和设备之间的关系，包含绑定和未绑定
     */
    Page queryEquimentRelation(CommonPageable commonPageable, String equipmentId, String fname);

    List<Map<String, Object>> listEquipmentPointById(Long fmeaId, Long importantEquipId, Long equipmentId, String equipmentPointName);

    Page<Map<String, Object>> listFmeaPointInputitem(String toke,String product,String appKey,Long fmeaId, Integer pageNumber, Integer pageSize);

    Page<Map<String, Object>> listFeamEquipmentPoint(Long fmeaId, Integer pageNumber, Integer pageSize);

    /**
     * 处理巡检数据和设备数据
     */
    String processFireEqumtData(FireEquimentDataRo deviceData) throws Exception;

    boolean processTaskData(ProtalDataRo taskData) throws Exception;

    void processProtalData(String toke,String product,String appKey,ProtalDataRo protalData) throws Exception;

    RiskSourceTreeResponse queryRiskSourceDetailById(Long id);

    /**
     * 三维图统计
     */
    Map queryFor3DStatistics();

    Map earlyWarning(Long riskSourceId);

    List<HashMap<String, Object>> queryRiskAreaRpn();

    String processFireEqumtData(AlarmParam deviceData) throws Exception;

    void saveData(List<AlarmParam> deviceDatas, String type);

    List<HashMap<String, Object>> queryRiskSourceSecondLevel(String compCode);

    List<RiskSourceTreeResponse> findRiskSourceEquipStatistics();

    List<RiskSourceTreeResponse> findRiskSourceEquipStatistics(String[] type);

    List<RiskSourceTreeResponse> getCheckPointRiskSources();

    void queryContingencyDeviceStatus(ContingencyDeviceStatus contingencyDeviceStatus);

    List<Map> queryContingencyWater();

    List<Map> queryFmeaByPointId(Long pointId);

    Integer getChildTypeByPid(Long riskSourceId);

    void notifyFmeaFromAbnormal(String toke,String product,String appKey,Long fmeaId, String notifyType,String userName, String relationName);

    void notifyFmeaFromUpdate(String toke,String product,String appKey,Long fmeaId, String nofityType,String userName);

    /**
     * 按照机构重新区域树
     * @param orgCode 机构
     * @return 树
     */
	List<RegionTreeResponse> findRegionTree(String channelType,String orgCode);

    /**
     * 区域详情重新
     * @param id 主键
     * @param orgCode 机构
     * @return map
     */
	HashMap<String, Object> findRegionById(Long id,String orgCode,String channelType);

    /**
     * 批量保存区域信息
     * @param regionBoList 参数数组
     */
	void batchSaveRegionUe4(List<BindRegionBo> regionBoList);

    void notifyRiskSource(Long fmeaId, Long riskSourceId, String notifyType, JpushMsgBo jpushMsgBo);

    void notifyFmeaFromDelete(Long handId, String from);

    void notifyRiskSourceDelete(Long handId);
}
