package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IRiskFactorService;
import com.yeejoin.amos.fas.business.util.CommonPageParamUtil;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.request.CommonRequest;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.RiskFactor;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping("/api/riskFactor")
@Api("危险因素api")
public class RiskFactorController extends BaseController {
    private final Logger log = LoggerFactory.getLogger(RiskFactorController.class);
    @Autowired
    IRiskFactorService iRiskFactorService;

    /**
     * 危险因素分页查询
     */
    @ApiOperation(httpMethod = "POST", value = "危险因素查询", notes = "危险因素查询")
    @RequestMapping(value = "/pagelist", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryRiskFactorPage(@ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
                                              @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<HashMap<String, Object>> list = iRiskFactorService.queryRiskFactorPage(getToken(),getProduct(),getAppKey(),param);
        return CommonResponseUtil.success(list);
    }


    /**
     * 危险因素查询，不分页
     */
    @ApiOperation(httpMethod = "GET", value = "危险因素查询不分页", notes = "危险因素查询不分页")
    @RequestMapping(value = "/all-list", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRiskFactor() {
        List<RiskFactor> list = iRiskFactorService.queryRiskFactor();
        return CommonResponseUtil.success(list);
    }

    /**
     * 危险因素新增及维护
     */
    @ApiOperation(httpMethod = "POST", value = "危险因素新增及维护", notes = "危险因素新增及维护")
    @RequestMapping(value = "/editRiskFactor", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse checkPlanAdd(@ApiParam(value = "危险因素对象", required = true) @RequestBody RiskFactor param) {
        try {
            Long count = iRiskFactorService.countRepeatData(param);
            if (count > 0) {
                return CommonResponseUtil.failure("危险因素名称重复：" + param.getName());
            }
            AgencyUserModel user = getUserInfo();
			ReginParams reginParams =getSelectedOrgInfo();
			String dep=getDepartmentId(reginParams);
			String compCode=getOrgCode(reginParams);
            HashMap<String, Object> map = new HashMap<>();
            map.put("org_code", compCode);
            map.put("user_id", user.getUserId());
            map.put("dept_id", dep);
            map.put("param", param);
            iRiskFactorService.editRiskFactor(map);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("危险因素编辑失败：" + e.getMessage());
        }
    }

    /**
     * 危险因素删除（支持批量）
     */
    @ApiOperation(httpMethod = "POST", value = "删除危险因素", notes = "删除危险因素")
    @RequestMapping(value = "/deleteRiskFactorById", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteRiskFactorById(@ApiParam(value = "危险因素ID", required = true) @RequestBody Long[] param) {
        try {
            iRiskFactorService.detRiskFactor(param);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure(e.getMessage() + ",危险因素删除失败");
        }
    }

}
