package com.yeejoin.amos.fas.business.dao.repository;

import java.util.List;
import java.util.Optional;

import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import com.yeejoin.amos.fas.dao.entity.FireEquipment;

@Repository("iFireEquipmentDao")
public interface IFireEquipmentDao extends BaseDao<FireEquipment, Long> {

	@Query(value = "select distinct production_area from f_fire_equipment ",nativeQuery = true)
	List<String> findFireEquipArea();
	
	Optional<FireEquipment> findById(Long id);

	@Query(value = "SELECT count(1) FROM `f_fire_station_equipment` WHERE fire_equipment_id in ?1", nativeQuery = true)
	int countAssociatedEquipStationByIds(String[] ids);
}
