package com.yeejoin.amos.fas.business.action.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;

import lombok.Data;

@RuleFact(value = "动态预案",project = "换流站消防专项预案")
@Data
public class ContingencyRo implements Serializable {
	@Label("批次号")
    private String batchNo;
    /**
	 * 
	 */
	private static final long serialVersionUID = 1863437780244849215L;
	@Label("消防设备名称")
	private String fireEquipmentName;//消防设备名称
	@Label("消防设备id")
    private String fireEquipmentId;//消防设备id


    private Integer  layer=0;//显示图层
    //当前探测器
    @Label("当前探测器图层")
    private Integer fireEquipmentLayer=0;//当前探测器图层
    @Label("消防设备位置")
    private String  fireEquipmentPosition;//消防设备位置

    //重点设备信息
        //负责人名称，手机号
    @Label("重点设备id")
    private  String  equipmentId;//重点设备id
    
    @Label("重点设备组织编码")
    private  String  equipmentOrgCode="10";//重点设备组织编码
    
    @Label("重点设备名称")
    private String   equipmentName;
    @Label("重点设备坐标")
    private String equipmentPosition3d;
    @Label("负责人手机号")
    private String mobile; //负责人手机号
    @Label("负责人名称")
    private String adminName;//负责人名称

    //摄像头
    @Label("摄像头编号")
    private String cameraCodes;//摄像头编号
    @Label("摄像头id")
    private String cameraIds;//摄像头id
    @Label("火情数量")
    private Integer fireCount = 1; //火情数量
    @Label("操作状态")
    private String confirm = "NONE";//是否确认火情，确认 CONFIRM,取消CANCEL,未操作 NONE

    private String picture1;
    private String picture2;
    private String picture3;
    private String picture4;
    @Label("路线")
    private String fireTruckRoute;
    @Label("是否已执行到下一步")
    private Boolean runstep; //是否已经执行流程
//    @Label("步骤")
    @Label("预案步骤")
    private String step;//当前步骤

    @Label("按钮编码")
    private String buttonCode;
    private String buttonState;
    @Label("步骤状态")
    private String stepState;//步骤操作状态
    @Label("重点设备编码")
    private String equipmentCode;
    
    private Date createDate = new Date();   
    
    @Label("遥测数据")
    private HashMap<String, Double> telemetryMap;
    
    @Label("遥信数据")
    private HashMap<String, Integer> telesignallingMap;

    //消防炮
    @Label("消防炮编号")
    private String fireMonitorCodes;
    @Label("消防炮id")
    private String fireMonitorIds;
}
