package com.yeejoin.amos.fas.business.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.fas.business.bo.BindPointBo;
import com.yeejoin.amos.fas.business.bo.BindRegionBo;
import com.yeejoin.amos.fas.business.param.RetrieveParams;
import com.yeejoin.amos.fas.business.service.intfc.IRiskSourceService;
import com.yeejoin.amos.fas.business.service.intfc.IView3dService;
import com.yeejoin.amos.fas.business.vo.ExceptionRegionVo;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.common.enums.ResourceTypeDefEnum;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import static com.yeejoin.amos.fas.business.constants.FasConstant.*;

@RestController
@RequestMapping("/api/view3d")
@Api(tags="全景监控api")
public class View3dController extends BaseController {
	@Autowired
	private IRiskSourceService riskSourceService;
	@Autowired
	private IView3dService view3dService;

	@Permission
	@ApiOperation(httpMethod = "POST", value = "点3d坐标设置", notes = "按照点类型3d坐标设置" )
	@PostMapping(value = "/point/bind",produces = "application/json;charset=UTF-8")
	public CommonResponse setPoint3dPosition(@ApiParam(name = "参数",required = true) @RequestBody List<BindPointBo> pointBoList){
		return view3dService.setPoint3dPosition(pointBoList);
	}
	
	@Permission
	@ApiOperation(value = "区域树查询", notes = "区域树查询")
    @GetMapping(value = "/region/tree")
    public CommonResponse getRegionTree() {
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		String channelType = this.getChannelType();
        return CommonResponseUtil.success(riskSourceService.findRegionTree(channelType,orgCode));
    }
	
	@Permission
	@ApiOperation(value = "区域详情查询", notes = "区域详情查询")
    @GetMapping(value = "region/detail/{riskSourceId}")
    public CommonResponse getRegionDetail(@PathVariable("riskSourceId") Long riskSourceId) {
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		String channelType = this.getChannelType();
        return CommonResponseUtil.success(riskSourceService.findRegionById(riskSourceId,orgCode,channelType));
    }
	
	@Permission
	@ApiOperation(value = "区域绑定", notes = "区域绑定")
	@PostMapping(value="region/bind")
	public CommonResponse batchSaveRegionUe4(@ApiParam(name = "区域参数列表",required = true) @RequestBody List<BindRegionBo> regionBoList) {
		try {		
			ReginParams reginParams =getSelectedOrgInfo();
			String orgCode = this.getOrgCode(reginParams);
			riskSourceService.batchSaveRegionUe4(regionBoList,orgCode);
		} catch (Exception e) {
			return CommonResponseUtil.failure(e.getMessage());
		}
        return CommonResponseUtil.success();
    }
	
	@Permission
	@ApiOperation(value = "点类型查询", notes = "点类型查询")
    @GetMapping(value = "point/type")
    public CommonResponse getPointType() {
        return CommonResponseUtil.success(view3dService.getPointType());
    }
	
	@Permission
	@ApiOperation(value = "按照分类查询点树", notes = "按照分类查询点树")
    @GetMapping(value = "point/tree/{type}")
    public CommonResponse getPointTreeByType(@PathVariable(value="type") String type) {
		if(ResourceTypeDefEnum.containsTypeCode(type)) {
			ReginParams reginParams =getSelectedOrgInfo();
			String orgCode = this.getOrgCode(reginParams);
			String channelType = this.getChannelType();
			return CommonResponseUtil.success(view3dService.getPointTreeByType(type,orgCode,channelType));
		}
		return CommonResponseUtil.failure(type + " 类型不存在");
    }
	
	@Permission
	@ApiOperation(value = "按照不同类型查询点详情", notes = "按照不同类型查询点详情")
    @GetMapping(value = "point/detail")
    public CommonResponse getPointDetail(@RequestParam String type,@RequestParam Long pointId) {
		return CommonResponseUtil.success(view3dService.getPointDetailByTypeAndId(type,pointId));
    }
	
	@Permission
	@ApiOperation(value = "一周安全指数趋势查询", notes = "一周安全指数趋势查询")
    @GetMapping(value = "safetyIndex/week")
    public CommonResponse safetyIndexWeek(String type,Long pointId) {
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getSafetyIndexWeek(orgCode));
    }

	@Permission
    @ApiOperation(value = "今日安全指数查询",notes = "按照日期查询安全指数及分类数据")
	@GetMapping(value = "/statistics/safetyIndex")
	public CommonResponse getSafetyIndexInfoByDate(@RequestParam(name = "date",required = false) String date){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getSafetyIndexInfoByDate(orgCode,date));
	}

	@Permission
	@ApiOperation(value = "今日安全指数详情",notes = "今日安全指数详情")
	@GetMapping(value = "/safetyIndex/detail/{type}")
	public CommonResponse getSafetyIndexDetail(@ApiParam(value = "risk-风险异常,check-巡检异常,equip-设备故障") @PathVariable String type){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getSafetyIndexDetail(type,orgCode));
	}

	@Permission
	@ApiOperation(value = "查询上线的年日",notes = "查询上线年日：10年101")
	@GetMapping(value = "/online/date")
	public CommonResponse getSystemOnlineDate(){
		//TODO: 多机构暂时不支持
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getSystemOnlineDate(orgCode));
	}
	
	@Permission
	@ApiOperation(value = "今日巡检统计接口",notes = "今日巡检统计接口")
	@GetMapping(value = "statistics/check")
	public CommonResponse getStatisticsCheck(){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getStatisticsCheck(orgCode));
	}
	
	@ApiOperation(value = "异常显示最新5条",notes = "异常显示最新5条")
	@GetMapping(value = "safetyExecute/list/{type}")
	public CommonResponse getSafetyExecuteListTop5(@PathVariable("type")String type){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getSafetyExecuteListTop5(type,orgCode));
	}
	
	@Permission
	@ApiOperation(value = "今日值班统计",notes = "今日值班统计")
	@GetMapping(value = "statistics/duty")
	public CommonResponse getStatisticsDuty(){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		appKey = getAppKey();
		product = getProduct();
		staticOrgCode = orgCode;
		token = getToken();
		return view3dService.getStatisticsDuty(getAppKey(),getProduct(),token,orgCode);
	}

	@Permission
	@ApiOperation(value = "异常区域信息查询",notes = "异常区域信息查询")
	@GetMapping(value = "region/exception/list")
	public CommonResponse getExceptionRegion(){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		List<ExceptionRegionVo> exceptionRegionVoList = view3dService.getExceptionRegion(orgCode);
		return CommonResponseUtil.success(exceptionRegionVoList);
	}
	
	@Permission
	@ApiOperation(value = "设备状态信息查询",notes = "设备状态信息查询")
	@GetMapping(value = "equipStatus/list")
	public CommonResponse getEquipStatusList(){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.getEquipStatusList(orgCode));
	}
	
	@Permission
	@ApiOperation(value = "3d视图点显示",notes = "3d视图点显示")
	@GetMapping(value = "initViewNode")
	public CommonResponse initViewNode(String type,Long riskSourceId){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return CommonResponseUtil.success(view3dService.initViewErrorNode(type,riskSourceId,orgCode));
	}

	@Permission
	@ApiOperation(value = "按照点类型查询点列表",notes = "按照点类型查询点列表")
	@GetMapping(value = "point/list")
	public CommonResponse get3dPointsByType(@RequestParam(required = false,defaultValue = "grain") String model){
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		return view3dService.get3dPointsByModel(orgCode,model);
	}
	
	@Scheduled(cron = "${param.safetyIndexChange.cron}")
	public CommonResponse safetyIndexLog(){
		view3dService.safetyIndexLogGenJob(null);
		return CommonResponseUtil.success();
	}

	@Permission
	@ApiOperation(value = "安全指数日流生成",notes = "安全指数日流生成定时任务")
	@GetMapping(value = "safetyIndex/schJobTest")
	public CommonResponse safetyIndexLog(@ApiParam(value = "格式:yyyy-MM-dd") @RequestParam String runData){
		view3dService.safetyIndexLogGenJob(runData);
		return CommonResponseUtil.success();
	}
	
	 /**
     * 二级区域风险等级，风险值
     *
     * @return
     */
    @Permission
    @ApiOperation(httpMethod = "GET", value = "二级区域风险等级，风险值", notes = "二级区域风险等级，风险值")
    @RequestMapping(value = "/secondLevelRiskSource", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRiskSourceSecondLevel() {
    	ReginParams reginParams = getSelectedOrgInfo();
		String compCode = getOrgCode(reginParams);
        return CommonResponseUtil.success(riskSourceService.queryRiskSourceSecondLevel(compCode));
    }

	/**
     * <pre>
     * 初始化三维视图节点
     * </pre>
     */
	@Permission
    @GetMapping(value = "/init3dViewNode", produces = "application/json;charset=UTF-8")
    @ApiOperation(value = "初始化三维视图节点", notes = "初始化三维视图节点")
    public CommonResponse init3dViewNode(
            @ApiParam(value = "节点类型", required = false) @RequestParam(required = false) String type,
            @ApiParam(value = "区域ID", required = false) @RequestParam(required = false) Long riskSourceId,
            @ApiParam(value = "异常状态", required = false) @RequestParam(required = false) Boolean abnormalStatus) {
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
        return CommonResponseUtil.success(view3dService.find3dViewDataByType(type,riskSourceId,orgCode,abnormalStatus));
    }
    
	@Permission
    @PostMapping(value = "/retrieve/all",produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "右侧边栏搜索", notes = "右侧边栏搜索")
	public CommonResponse retrieveAll(
			@RequestBody RetrieveParams params
			) {
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		String token = this.getToken();
		String appKey = this.getAppKey();
		String product = this.getProduct();
		
    	return view3dService.retrieveAll(params.getType(),
    			params.getRiskSourceId(),
    			params.getInputText(),
    			params.getCurrent(),
    			params.getPageSize(),
    			orgCode,
    			params.getDataLevel(),
    			params.getProtectObjName(),
    			token,appKey,product);
    }
    
	@Permission
    @ApiOperation(value = "等级查询",notes = "等级查询")
	@GetMapping(value = "point/level")
	public CommonResponse pointLevel(@ApiParam(value = "点类型") @RequestParam String type){
		return CommonResponseUtil.success(view3dService.pointLevelList(type));
	}
	
	@Permission
	@ApiOperation(value = "重新区域下包含点",notes = "重新区域下包含点")
	@GetMapping(value = "point/list/{regionId}")
	public CommonResponse listPointsByRegion(@PathVariable Long regionId, @RequestParam(required = false, defaultValue = "all") String type){
		return  CommonResponseUtil.success(view3dService.listPointsByRegionId(regionId,type));
	}

}
