package com.yeejoin.amos.fas.business.dao.repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.fas.dao.entity.RiskSource;

@Repository("iRiskSourceDao")
public interface IRiskSourceDao extends BaseDao<RiskSource, Long> {

	List<RiskSource> findByRiskLevelId(Long id);
	
	List<RiskSource> findAll();

	List<RiskSource> findByParentId(Long parentId);
	
	int countByParentId(Long parentId);
	
	Optional<RiskSource> findById(Long id);
	
	
	/**
	 * 获取厂区下所有区域的rpn值
	 * 

	 * @return
	 */
	@Modifying
	@Query(value="select *from f_risk_source where is_region = 'TRUE' and parent_id > 0", nativeQuery = true)
	List<RiskSource>  queryRiskAreaRpn();


    Optional<RiskSource> findByOrgCodeAndParentId(String orgCode, Long parentId);

	List<RiskSource> findByParentIdAndIsRegion(long id, String string);

	Optional<RiskSource> findByCode(String riskSourceCode);
}
