package com.yeejoin.amos.fas.business.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.yeejoin.amos.fas.core.util.CommonResponse;

@FeignClient(name="${equipManage.fegin.name}", fallback=MassVisualFallback.class, configuration=FeignConfiguration.class)
public interface IEquipManageFeign {
    /**
     * 
     * 远程保存仓库，如果id存在就更新，不存在就新增。 
     *
     * @param appKey
     * @param product
     * @param token
     * @param param
     * @return CommonResponse
     * @throws <br>
     * @author 张展弋
     * @date 2020-9-8 15:15:18
     */
    @RequestMapping(value = "/equip/warehouse/saveAutoSysSyn", method = RequestMethod.POST,consumes = "application/json")
    public CommonResponse saveWarehouse(
            @RequestHeader(name="appKey",required = true) String appKey,
            @RequestHeader(name="product",required = true) String product,
            @RequestHeader(name="token",required = true) String token,
            @RequestBody String param);
    
    /**
     * 
     * 远程删除仓库
     *
     * @param appKey
     * @param product
     * @param token
     * @param riskSourceId 网络传输不支持long这边传string那边long接
     * @return CommonResponse
     * @throws <br>
     * @author 张展弋
     * @date 2020-9-8 17:43:11
     */
    @RequestMapping(value = "/equip/warehouse/deleteAutoSysSyn", method = RequestMethod.POST,consumes = "application/json")
    public CommonResponse delWarehouse(
            @RequestHeader(name="appKey",required = true) String appKey,
            @RequestHeader(name="product",required = true) String product,
            @RequestHeader(name="token",required = true) String token,
            @RequestBody String riskSourceId);
    
}
