package com.yeejoin.amos.fas.core.enums;

/**
 * @ProjectName: YeeAmosFireAutoSysRoot
 * @Package: com.yeejoin.amos.fas.core.enums
 * @ClassName: ReserveEnum
 * @Author: Jianqiang Gao
 * @Description: 预案启动状态
 * @Date: 2021/1/7 18:23
 * @Version: 1.0
 */
public enum ReserveEnum {
    RUN(1, "启动成功"),
    RUNNING(2, "已有预案正在启动"),
    NOFIRE(3, "该电力设备未安装火灾探测器"),
    NOEQUIP(4, "未找到该电力设备");

    private Integer status;
    private String text;

    ReserveEnum(Integer status, String text) {
        this.status = status;
        this.text = text;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }
}