package com.yeejoin.amos.fas.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *0、运行中，1、完毕，3、中断
 *  @author suhg
 */

public enum DutyPersonEnum {
    FIRE_PERSON("驻站消防","fire"),
    OPS_PERSON("运维人员","ops"),
    REAL_PERSON("物业安保","realEstate");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    /**
     * 颜色
     */
    private String color;


    private DutyPersonEnum(String name, String code){
        this.name = name;
        this.code = code;
    }

    public static DutyPersonEnum getEnum(String code) {
        DutyPersonEnum checkStatusEnum = null;
        for(DutyPersonEnum type: DutyPersonEnum.values()) {
            if (type.getCode().equals(code)) {
                checkStatusEnum = type;
                break;
            }
        }

        return checkStatusEnum;
    }

    public static List<Map<String,Object>> getEnumList() {
        List<Map<String,Object>> nameList = new ArrayList<>();
        for (DutyPersonEnum c: DutyPersonEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("name", c.getName());
            map.put("code", c.getCode());
            nameList.add(map);
        }
        return nameList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

