package com.yeejoin.amos.fas.dao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;


@Data
@Accessors(chain = true)
@TableName("contingency_instance_info")
@ApiModel(value = "应急预案执行记录实例", description = "应急预案执行记录实例")
public class ContingencyInstanceInfo extends Model<ContingencyInstanceInfo>{
    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.ID_WORKER_STR)
    @JsonSerialize(using = ToStringSerializer.class)
    private String id;

    private String name;

    private String position;

    private String equipmentCode;

    private String equipmentName;

    private Date startTime;

    private Date endTime;

    private Boolean isDelete = false;

    private Date createDate;

    private String orgCode;

    @TableField
    private String duration;


}
