package com.yeejoin.amos.fas.business.controller;

import java.util.HashMap;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.service.intfc.IAccidentTypeService;
import com.yeejoin.amos.fas.business.util.CommonPageParamUtil;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.request.CommonRequest;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.AccidentType;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping("/api/accidentType")
@Api("事故类型api")
public class AccidentTypeController extends BaseController {
	private final Logger log = LoggerFactory.getLogger(AccidentTypeController.class);
	@Autowired 
	IAccidentTypeService iAccidentTypeService;
	/**
	 * 事故类型分页查询
	 * 
	 * @param id
	 * @return
	 */
	@Permission
	@ApiOperation(httpMethod = "POST",value = "事故类型查询", notes = "事故类型查询")
	@RequestMapping(value = "/pagelist", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse queryRiskLevelPage(@ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
			@ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
		CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
		ReginParams reginParams =getSelectedOrgInfo();
		String orgCode = this.getOrgCode(reginParams);
		param.setOrgCode(orgCode);
		Page<HashMap<String, Object>> list = iAccidentTypeService.queryAccidentTypePage(getToken(),getProduct(),getAppKey(),param);
		return CommonResponseUtil.success(list);
	}
	
	
	/**
	 * 事故类型查询，不分页
	 * 
	 * @param id
	 * @return
	 */
	@Permission
	@ApiOperation(httpMethod = "GET",value = "事故类型查询不分页", notes = "事故类型查询不分页")
	@RequestMapping(value = "/all-list", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse queryRiskLevel() {
		ReginParams reginParams =getSelectedOrgInfo();
		String compCode=getOrgCode(reginParams);
		List<HashMap<String,Object>> list = iAccidentTypeService.queryAccidentType(compCode);
		return CommonResponseUtil.success(list);
	}
	
	/**
	 * 事故类型新增及维护
	 * @param param
	 * @return
	 */
	@Permission
	@ApiOperation(httpMethod = "POST", value = "事故类型新增及维护", notes = "事故类型新增及维护")
	@RequestMapping(value = "/editAccidentType", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse checkPlanAdd(@ApiParam(value = "事故类型对象", required = true) @RequestBody AccidentType param) {
		try {
			AgencyUserModel user = getUserInfo();
			ReginParams reginParams =getSelectedOrgInfo();
			String dep=getDepartmentId(reginParams);
			String compCode=getOrgCode(reginParams);
			
			HashMap<String,Object> map = new HashMap<String,Object>();	
			map.put("dept_id", dep);
			map.put("org_code", compCode);
			map.put("user_id", user.getUserId());
			map.put("param", param);
			iAccidentTypeService.editAccidentType(map);
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(),e);
			return CommonResponseUtil.failure("事故类型编辑失败" + e.getMessage());
		}
	}
	
	/**
	 * 事故类型删除（支持批量）
	 * @param param
	 * @return
	 */
	@Permission
	@ApiOperation(httpMethod = "POST", value = "删除事故类型", notes = "删除事故类型")
	@RequestMapping(value = "/deleteAccidentTypeById", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	public CommonResponse deletePlanById(@ApiParam(value = "事故类型ID", required = true) @RequestBody  Long[] param) {		
		try {
			iAccidentTypeService.detAccidentType(param);
			return CommonResponseUtil.success();
		} catch (Exception e) {
			log.error(e.getMessage(),e);
			return CommonResponseUtil.failure(e.getMessage()+",事故类型删除失败");
		}
	}
	
}
