package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.service.intfc.ContingencyInstanceInfoService;
import com.yeejoin.amos.fas.business.vo.ReginParams;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil2;
import com.yeejoin.amos.fas.core.util.ResponseModel;
import com.yeejoin.amos.fas.dao.entity.ContingencyInstanceInfo;
import com.yeejoin.amos.fas.exception.YeeException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping(value = "/plan/record")
@Api(tags = "应急预案执行记录实例")
public class ContingencyInstanceInfoController extends BaseController {


    @Autowired
    private ContingencyInstanceInfoService contingencyInstanceInfoService;


    @Permission
    @ApiOperation(value = "应急预案执行记录信息", notes = "应急预案执行记录信息")
    @GetMapping(value = "/selectDisposalDetails")
    public ResponseModel selectDisposalDetails(@RequestParam("batchNo") String batchNo) {
        return CommonResponseUtil.successNew(contingencyInstanceInfoService.selectDisposalDetails(batchNo));
    }


    @Permission
    @ApiOperation(httpMethod = "GET", value = "分页查询应急预案执行记录信息", notes = "分页查询应急预案执行记录信息")
    @GetMapping(value = "/selectDisposalListPage")
    public ResponseModel selectDisposalListPage(@RequestParam(value = "current") int current,
                                                @RequestParam(value = "size") int size
    ) {
        if (current < 1 || size < 1) {
            throw new YeeException("分页参数有误");
        }
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getOrgCode(reginParams);
        return CommonResponseUtil2.success(contingencyInstanceInfoService.selectDisposalListPage(current, size, orgCode));
    }

    @Permission
    @ApiOperation(value = "新增应急预案执行记录", notes = "新增应急预案执行记录")
    @PostMapping(value = "/addDisposalDetails")
    public ResponseModel addDisposalDetails(@RequestBody ContingencyInstanceInfo contingencyInstanceInfo) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getOrgCode(reginParams);
        contingencyInstanceInfo.setOrgCode(orgCode);
        return CommonResponseUtil.successNew(contingencyInstanceInfoService.addDisposalDetails(contingencyInstanceInfo));
    }

    @Permission
    @ApiOperation(value = "修改应急预案执行记录信息", notes = "修改应急预案执行记录信息")
    @PostMapping(value = "/updateDisposalDetails")
    public ResponseModel updateDisposalDetails(@RequestBody ContingencyInstanceInfo contingencyInstanceInfo) {
        return CommonResponseUtil.successNew(contingencyInstanceInfoService.updateDisposalDetails(contingencyInstanceInfo));
    }
}
