package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.service.intfc.IEquipmentFireEquipmentService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ProjectName: YeeAmosFireAutoSysRoot
 * @Package: com.yeejoin.amos.fas.business.controller
 * @ClassName: equipmentFireEquipmentController
 * @Author: Jianqiang Gao
 * @Description: equipmentFireEquipmentController
 * @Date: 2022/5/23 10:11
 * @Version: 1.0
 */
@RestController
@RequestMapping(value = "/api/equipFireEquip")
public class EquipmentFireEquipmentController {

    @Autowired
    private IEquipmentFireEquipmentService equipmentFireEquipmentService;

    @ApiOperation(value = "判断是否自动执行", notes = "判断是否自动执行")
    @GetMapping("/automaticExecute")
    public Object automaticExecute(@RequestParam(required = false) String equipmentId,
                                   @RequestParam(required = false) String equipCode,
                                   @RequestParam(required = false) String equipSpeCode,
                                   @RequestParam(required = false) String type,
                                   @RequestParam(required = false) String indexKeys,
                                   @RequestParam(required = false) String value) {
        return equipmentFireEquipmentService.automaticExecute(equipmentId, equipCode, equipSpeCode, type, indexKeys, value);
    }

    @ApiOperation(value = "判断节点是否自动执行", notes = "判断节点是否自动执行")
    @GetMapping("/automaticExecutePoint")
    public Object automaticExecutePoint(@RequestParam(required = false) Integer index) {
        return equipmentFireEquipmentService.automaticExecutePoint(index);
    }

}