package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.fas.business.service.intfc.IContingencyPlanService;
import com.yeejoin.amos.fas.business.util.StringUtil;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil2;
import com.yeejoin.amos.fas.core.util.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping("/api/instructions")
@Api(tags = "指令流查询API")
public class InstructionsController {

    @Autowired
    IContingencyPlanService iContingencyPlanService;

    /**
     * 指令流查询API
     */
    @Permission
    @ApiOperation(value = "指令流查询API", notes = "指令流查询API")
    @GetMapping(value = "/getBatchNoByCode", produces = "application/json;charset=UTF-8")
    public ResponseModel getBatchNoByCode(@RequestParam(value = "code") String code) {
        if (StringUtils.isEmpty(code)) {
            return CommonResponseUtil2.failure("参数有误");
        }
        return CommonResponseUtil2.success(iContingencyPlanService.getBatchNoByCode(code));
    }
}
