package com.yeejoin.amos.fas.business.dao.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.fas.business.vo.ContingencyInstanceInfoVO;
import com.yeejoin.amos.fas.business.vo.ContingencyPlanInstanceVO;
import com.yeejoin.amos.fas.dao.entity.ContingencyInstanceInfo;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface ContingencyInstanceInfoMapper extends BaseMapper<ContingencyInstanceInfo> {

    ContingencyInstanceInfoVO selectDisposalDetails(@Param("id") String id);

    Boolean addDisposalDetails(@Param("dto") ContingencyInstanceInfo contingencyInstanceInfo);

    Boolean updateDisposalDetails(@Param("dto") ContingencyInstanceInfo contingencyInstanceInfo);

    int selectCount(@Param("orgCode") String orgCode);

    List<ContingencyInstanceInfoVO> selectDisposalListPage(@Param("current") int current, @Param("size") int size, @Param("orgCode") String orgCode);

    List<ContingencyPlanInstanceVO> selectDisposalActionPage(@Param("current") int current, @Param("size") int size,@Param("type") String type, @Param("status") String status,@Param("list") List<String> roles ,@Param("batchNo") String batchNo);

    List<ContingencyPlanInstanceVO> selectTaskActionPage(@Param("current") int current, @Param("size") int size,@Param("type") String type, @Param("status") String status,@Param("list") List<String> roles ,@Param("batchNo") String batchNo);

    int selectCountDisposalActionPage(@Param("type") String type, @Param("status") String status,@Param("list") List<String> roles ,@Param("batchNo") String batchNo);

    int selectCountTaskActionPage(@Param("type") String type, @Param("status") String status,@Param("list") List<String> roles ,@Param("batchNo") String batchNo);

    List<ContingencyPlanInstanceVO> selectDisposalActionList(@Param("type") String type, @Param("status") String status, @Param("list") List<String> roles , @Param("batchNo") String batchNo);

    List<ContingencyPlanInstanceVO> selectTaskActionList(@Param("type") String type, @Param("status") String status, @Param("list") List<String> roles , @Param("batchNo") String batchNo);

    List<ContingencyPlanInstanceVO> getTaskActionList(@Param("type") String type, @Param("status") String status, @Param("batchNo") String batchNo);

    int countTaskPage(@Param("type") String type, @Param("batchNo") String batchNo, @Param("list") List<String> roles);

    List<ContingencyPlanInstanceVO> getTaskActionPage(@Param("current") int current, @Param("size") int size, @Param("batchNo") String batchNo, @Param("type") String type, @Param("runState") String runState, @Param("updateDate") String updateDate, @Param("list") List<String> roles);

}
