package com.yeejoin.amos.fas.business.event;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.fas.business.action.ContingencyAction;
import com.yeejoin.amos.fas.business.action.model.ContingencyEvent;
import com.yeejoin.amos.fas.business.action.model.ContingencyRo;
import com.yeejoin.amos.fas.business.action.result.SafteyPlanResult;
import com.yeejoin.amos.fas.business.action.util.ContingencyLogPublisher;
import com.yeejoin.amos.fas.business.dao.mapper.*;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyOriginalDataDao;
import com.yeejoin.amos.fas.business.dao.repository.IContingencyPlanInstanceRepository;
import com.yeejoin.amos.fas.business.service.intfc.*;
import com.yeejoin.amos.fas.business.service.model.ToipResponse;
import com.yeejoin.amos.fas.business.vo.ContingencyInstanceInfoVO;
import com.yeejoin.amos.fas.dao.entity.ContingencyOriginalData;
import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.fas.dao.entity.Equipment;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: FireContingencyHandler
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2023/4/4 16:33
 */
@Component
public class FireContingencyHandler implements EventHandler{


    private static final Logger log = LoggerFactory.getLogger(FireContingencyHandler.class);

    @Autowired
    IContingencyOriginalDataDao iContingencyOriginalDataDao;

    @Autowired
    private ImpAndFireEquipMapper impAndFireEquipMapper;

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private ContingencyLogPublisher contingencyLogPublisher;
    @Autowired
    private PlanDetailMapper planDetailMapper;

    @Autowired
    IRocketMQService rocketMQService;

    @Autowired
    private ContingencyInstanceInfoService contingencyInstanceInfoService;


    @Autowired
    private IContingencyInstance iContingencyInstance;

    @Autowired
    ContingencyAction contingencyAction;

    @Autowired
    IContingencyOriginalDataDao contingencyOriginalDataDao;

    @Autowired
    private ContingencyInstanceInfoMapper contingencyInstanceInfoMapper;

    @Autowired
    private RuleTrigger ruleTrigger;

    private static Map<String, String> stepMap = new HashMap<>();

    @Value("${spring.application.name}")
    private String serviceName;

    @Value("${station.name}")
    private String stationName;

    @Override
    public void handler(ContingecyExecEvent event) throws Exception {

        /**
         * TODO 只处理调用触发下次原，不错业务数据更新
         */
        fire(event.getPlanExecute().getBatchNo(),
                event.getPlanExecute().getStepCode(),
                event.getPlanExecute().getContingencyPlanId(),
                event.getPlanExecute().getButtonCode(),
                event.getPlanExecute().getConfirm(),
                event.getPlanExecute().getStepState());
    }

    @Override
    public String getEventType() {
        return EventType.FIRE_NEXT_RULE.name();
    }


    public void fire(String batchNo, String stepCode, String contingencyPlanId, String buttonCode, String buttonState, String stepStateOnbutton) throws Exception {
        //火灾误报
        ContingencyOriginalData contingencyOriginalData = iContingencyOriginalDataDao.findByBatchNo(batchNo);

        String stepKey = batchNo + "_" + stepCode;
        if (stepMap.get(stepKey) == null)
            stepMap.put(stepKey, "");
        Equipment equipment;
        if (contingencyOriginalData != null) {
            log.info("数据库中的stepcode:" + contingencyOriginalData.getStep());
            contingencyOriginalData.setConfirm(buttonState);
            contingencyOriginalData.setRunstep(false);
            if (contingencyOriginalData.getStepState() == null)
                contingencyOriginalData.setStepState("");

            if ("CONFIRM".equals(buttonState)
                    && !contingencyOriginalData.getStepState().contains(stepStateOnbutton)
                    && stepCode.equals(contingencyOriginalData.getStep()))
                contingencyOriginalData.setStepState(contingencyOriginalData.getStepState() + stepStateOnbutton);

            //请求中的步骤小于以保存的步骤
//            if (Integer.parseInt(stepCode) < Integer.parseInt(contingencyOriginalData.getStep()) ) {
//                contingencyOriginalData.setRunstep(true);
//            }

            if (Integer.parseInt(stepCode) > Integer.parseInt(contingencyOriginalData.getStep())) {
                contingencyOriginalData.setStepState(stepStateOnbutton);
            }

            //使用原始数据触发规则
            if ("CONFIRM".equals(buttonState)
                    && !stepMap.get(stepKey).contains(stepStateOnbutton))
                stepMap.put(stepKey, stepMap.get(stepKey) + stepStateOnbutton);

            ContingencyRo contingencyRo = new ContingencyRo();
            contingencyRo.setButtonCode(buttonCode);
            contingencyRo.setButtonState(buttonState);

            ContingencyInstanceInfoVO infoVO = contingencyInstanceInfoService.selectDisposalDetails(batchNo);
            if (!ObjectUtils.isEmpty(infoVO.getPosition())) {
                contingencyOriginalData.setPosition(infoVO.getPosition());
            }

            BeanUtils.copyProperties(contingencyOriginalData, contingencyRo);
            contingencyRo.setStep(stepCode);
            contingencyRo.setStepState(stepMap.get(stepKey));
            String isMock = redisTemplate.boundValueOps("isMock").get(0, -1);
            if (isMock != null) {
                contingencyRo.setIsMock("true".equals(isMock));
            } else {
                contingencyRo.setIsMock(false);
            }
            log.info("stepstate:" + contingencyRo.getStepState());
            log.info("stepCode:" + stepCode);
            equipment = impAndFireEquipMapper.queryImpEqumtByFireEquipmt(Long.parseLong(contingencyRo.getFireEquipmentId()));
            if (equipment != null) {
                contingencyRo.setEquipmentCode(equipment.getCode());
                Map<String, Object> params = contingencyRo.getParams();
                params.put("appKey", RequestContext.getAppKey());
                params.put("product", RequestContext.getProduct());
                params.put("token", RequestContext.getToken());

                contingencyRo.setParams(params);

                List<String> plan = this.getNumberPlan(Long.parseLong(contingencyRo.getEquipmentId()));

                ruleTrigger.publish(contingencyRo, "换流站消防专项预案/" + plan.get(0), ArrayUtils.toArray(equipment.getName()));


            }

            iContingencyOriginalDataDao.updateByButton(
                    contingencyOriginalData.getConfirm(),
                    contingencyOriginalData.getRunstep(),
                    contingencyOriginalData.getStepState(),
                    batchNo
            );


            SafteyPlanResult result = new SafteyPlanResult();
            Map<String, Object> tempmap1 = new HashMap<>();
            try {
                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                List<ContingencyPlanInstance> list = iContingencyInstance.queryForTimeLine(contingencyRo.getBatchNo(), "MESSAGE");
                ArrayList records = new ArrayList<>();
                if (!ObjectUtils.isEmpty(list)) {
                    list.forEach(action -> {
                        HashMap map = new HashMap();
                        map.put("time", sdf1.format(action.getCreateDate().getTime()));
                        map.put("stepName", action.getContent());
                        records.add(map);
                    });
                }
                tempmap1.put("content", records);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            result.add(tempmap1);
            ContingencyRo paramObj = new ContingencyRo();
            paramObj.setBatchNo(contingencyRo.getBatchNo());
            contingencyAction.sendcmdT("recordarea", paramObj, result);
            if (equipment != null) {
                publisherPlanLog(stepCode, buttonCode, batchNo);
            }
        } else {
            throw new Exception("数据异常,请联系管理员.");
        }
        return;
    }

    public List<String> getNumberPlan(Long id) {
        List<String> ruleId = planDetailMapper.getRuleIdByEquipment(id);
        return ruleId;
    }

    private void publisherPlanLog(String stepCode, String buttonCode, String batchNo) {
        ContingencyEvent event = new ContingencyEvent(this);
        JSONObject json = new JSONObject();
        JSONObject msgContext = new JSONObject();
        JSONObject content = new JSONObject();
        content.put("stepCode", stepCode);
        content.put("buttonCode", buttonCode);
        msgContext.put("type", "clickEvent");
        msgContext.put("content", content);
        json.put("msgType", "message");
        json.put("msgContext", msgContext);
        event.setMsgBody(json.toJSONString());
        String topic = String.format("/%s/%s/%s", serviceName, stationName, "plan");
        event.setTopic(topic);
        event.setMsgType("clickEvent");
        event.setContingency(batchNo);
        contingencyLogPublisher.publish(event);
    }

}
