package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.EmergencyTaskMapper;
import com.yeejoin.amos.fas.business.service.intfc.IEmergencyTaskService;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.dao.entity.EmergencyRelation;
import com.yeejoin.amos.fas.dao.entity.EmergencyRelationTree;
import com.yeejoin.amos.fas.dao.entity.EmergencyTaskContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service
public class EmergencyTaskServiceImpl implements IEmergencyTaskService {

    @Autowired
    EmergencyTaskMapper emergencyTaskMapper;

    @Override
    public Page<EmergencyTaskContent> list(Long obligationId, CommonPageable pageable) {
        int total = emergencyTaskMapper.getEmergencyTaskCount(obligationId);
        List<EmergencyTaskContent> emergencyTaskList = emergencyTaskMapper.getEmergencyTaskList(obligationId, pageable.getOffset(), pageable.getPageSize());
        Page<EmergencyTaskContent> result = new PageImpl<>(emergencyTaskList, pageable, total);
        return result;

    }

    @Override
    public List<EmergencyRelationTree> treeList() {
        return emergencyTaskMapper.treeList();
    }

    @Override
    public void deleteTreeNode(Long obligationId, Long personId) {
        emergencyTaskMapper.deleteTreeNode(obligationId , personId);
    }

    @Override
    public void save(EmergencyRelation emergencyRelation) {
        emergencyTaskMapper.save(emergencyRelation);
    }

    @Override
    public String getRolesByUserId(String userId) {
        List<String> list = emergencyTaskMapper.roleCodes(userId);
        String roleCodes = String.join(",", list);
        return roleCodes;
    }

    @Override
    public String getRolesNameByUserId(String userId) {
        List<String> list = emergencyTaskMapper.roleNames(userId);
        String roleNames = String.join(",", list);
        return roleNames;
    }

    @Override
    public List<Long> getPersonIds(Long obligationId) {
        return emergencyTaskMapper.getPersonIds(obligationId);
    }

}
