package com.yeejoin.amos.fas.business.service.impl;

import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.fas.business.service.intfc.IRocketMQService;

@Service("rocketMQService")
public class RocketMQService implements IRocketMQService {
	
	private final Logger log = LoggerFactory.getLogger(RocketMQService.class);

	@Autowired
	@Qualifier("defaultProducer")
	DefaultMQProducer defaultMQProducer;

	@Autowired
	@Qualifier("defaultProducer1")
	DefaultMQProducer defaultMQProducer1;

	@Value("${rocketmq.producer.sysIsUsed}")
	private String sysIsUsed;
	 
	 public void sendMsg(String topic, String tag, Object msg){
	     try {
	    	 if("on".equalsIgnoreCase(sysIsUsed)){
	    		 log.info("rocketMQtopic===="+topic);
		    	 log.info("rocketMQmsg===="+JSON.toJSONString(msg).toString());
		    	 
		    	 Message sendMsg = new Message(topic, tag, JSON.toJSONString(msg).getBytes());
		    	 SendResult sendResult = defaultMQProducer.send(sendMsg);
				 
		    	 log.info("rocketMQsendResult===="+JSON.toJSONString(sendResult).toString()); 
	    	 }else{
	    		 log.info("rocketMQsendResult====rocketmq.producer.sysIsUsed is not on"); 
	    	 }
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error(e.getMessage(), e);
			e.printStackTrace();
		} 
	 }
}
