package com.yeejoin.amos.fas.business.service.intfc;


import com.yeejoin.amos.fas.dao.entity.ContingencyPlanInstance;
import com.yeejoin.amos.fas.datasync.bo.ContingencyOriginalDataSyncBo;
import com.yeejoin.amos.fas.datasync.bo.PlanDetailSyncBo;
import com.yeejoin.amos.fas.datasync.bo.PlanOperationRecordSyncBo;

import java.util.Collection;

/**
 * @ProjectName: YeeAMOSPatrolRoot
 * @Package: com.yeejoin.amos.patrol.business.service.intfc
 * @ClassName: IDataSyncService
 * @Author: Jianqiang Gao
 * @Description: IDataSyncService
 * @Date: 2022/5/30 10:48
 * @Version: 1.0
 */
public interface IDataSyncService {

    void asyncInvoke(AsyncExec consumer) throws Exception;

    @FunctionalInterface
    interface AsyncExec {
        void exec() throws Exception;
    }

    void syncCreatedPlanDetailSyncBo(PlanDetailSyncBo planOperationRecordSyncBo);

    void syncCreatedPlanDetailSyncBo(Collection<PlanDetailSyncBo> list);

    void syncDeletedPlanDetailSyncBo(Collection<Long> ids);

    void syncDeletedPlanDetailSyncBo(Long id);

    void syncUpdatedPlanDetailSyncBo(Collection<PlanDetailSyncBo> list);

    void syncCreatedPlanOperationRecordSyncBo(PlanOperationRecordSyncBo planOperationRecordSyncBo);

    void syncCreatedPlanOperationRecordSyncBo(Collection<PlanOperationRecordSyncBo> list);

    void syncDeletedPlanOperationRecordSyncBo(Collection<Long> ids);

    void syncDeletedPlanOperationRecordSyncBo(Long id);

    void syncUpdatedPlanOperationRecordSyncBo(Collection<PlanOperationRecordSyncBo> list);

    void syncCreatedContingencyOriginalDataSyncBo(ContingencyOriginalDataSyncBo contingencyOriginalDataSyncBo);

    void syncCreatedContingencyOriginalDataSyncBo(Collection<ContingencyOriginalDataSyncBo> list);

    void syncDeletedContingencyOriginalDataSyncBo(Collection<String> ids);

    void syncDeletedContingencyOriginalDataSyncBo(String id);

    void syncUpdatedContingencyOriginalDataSyncBo(Collection<ContingencyOriginalDataSyncBo> list);

    void syncCreatedContingencyPlanInstance(ContingencyPlanInstance contingencyPlanInstance);

    void syncCreatedContingencyPlanInstance(Collection<ContingencyPlanInstance> list);

    void syncDeletedContingencyPlanInstance(Collection<String> ids);

    void syncDeletedContingencyPlanInstance(String id);

    void syncUpdatedContingencyPlanInstance(Collection<ContingencyPlanInstance> list);

}
