package com.yeejoin.amos.fas.business.util;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.fas.business.service.intfc.IFormInstanceService;
import com.yeejoin.amos.fas.business.vo.FormInstanceVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ProjectName: YeeAmosFireAutoSysRoot
 * @Package: com.yeejoin.amos.fas.business.util
 * @ClassName: ScheduledUtil
 * @Author: Jianqiang Gao
 * @Description: 定时任务工具类
 * @Date: 2021/12/10 16:58
 * @Version: 1.0
 */
@Slf4j
@Component
public class ScheduledUtil {

    @Autowired
    private IFormInstanceService formInstanceService;

    @Autowired
    private RedisTemplate redisTemplate;

    @Value("${autoSys.fire.pool.index_key}")
    private String firePoolIndexKey;

    /**
     * 每日凌晨六点执行
     */
    @Scheduled(cron = "0 0 0 6 * ? ")
    synchronized private void saveWaterLevelByRedis() {
        List<FormInstanceVo> list = formInstanceService.queryFirePool(firePoolIndexKey);
        if (CollectionUtils.isNotEmpty(list)) {
            for (FormInstanceVo formInstanceVo : list) {
                redisTemplate.opsForValue().set("WaterLevel:Code:" + formInstanceVo.getIotCode(), JSON.toJSONString(formInstanceVo));
            }
        }
    }

    /**
     * 手动调用接口执行
     */
    public Boolean saveWaterLevelToRedis() {
        List<FormInstanceVo> list = formInstanceService.queryFirePool(firePoolIndexKey);
        if (CollectionUtils.isNotEmpty(list)) {
            for (FormInstanceVo formInstanceVo : list) {
                redisTemplate.opsForValue().set("WaterLevel:Code:" + formInstanceVo.getIotCode(), JSON.toJSONString(formInstanceVo));
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}