package com.yeejoin.amos.fas.business.vo;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.fas.business.util.StringUtil;
import com.yeejoin.amos.fas.core.common.response.CoordDTO;

public class View3dNodeVo {
	
	private Long id;
	private String name;
	private String code;
	private JSONArray ue4Location = new JSONArray();
	private JSONArray ue4Rotation = new JSONArray();
	private String type;
	private String key;
	private String[] relationKeys; 
	private String level;
	private String levelStr;
	private CoordDTO position;
	/**
	 * 顶牌内容
	 */
	private String title;
	/**
	 * 闪烁频率
	 */
	private Integer frequency = 0;
	/**
	 * 是否显示顶牌
	 */
	private Boolean showInfo;

	public Boolean getShowInfo() {
		return showInfo;
	}

	public void setShowInfo(Boolean showInfo) {
		this.showInfo = showInfo;
	}

	public Integer getFrequency() {
		return frequency;
	}

	public void setFrequency(Integer frequency) {
		this.frequency = frequency;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public JSONArray getUe4Location() {
		return ue4Location;
	}
	public void setUe4Location(String ue4Location) {
		this.ue4Location = StringUtils.isEmpty(ue4Location) ? new JSONArray() : JSONArray.parseArray(ue4Location);
	}
	public JSONArray getUe4Rotation() {
		return ue4Rotation;
	}
	public void setUe4Rotation(String ue4Rotation) {
		this.ue4Rotation = StringUtils.isEmpty(ue4Rotation) ? new JSONArray() : JSON.parseArray(ue4Rotation);
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public String[] getRelationKeys() {
		return relationKeys;
	}
	public void setRelationKeys(String relationKeys) {
		if(StringUtil.isNotEmpty(relationKeys)) {
			this.relationKeys = relationKeys.split(",");
		}
	}
	/**
	 * @return the level
	 */
	public String getLevel() {
		return level;
	}
	/**
	 * @param level the level to set
	 */
	public void setLevel(String level) {
		this.level = level;
	}
	/**
	 * @return the levelStr
	 */
	public String getLevelStr() {
		return levelStr;
	}
	/**
	 * @param levelStr the levelStr to set
	 */
	public void setLevelStr(String levelStr) {
		this.levelStr = levelStr;
	}

	/**
	 * @return the position
	 */
	public CoordDTO getPosition() {
		return position;
	}

	/**
	 * @param position the position to set
	 */
	public void setPosition(String position) {
		this.position = position == null?null:JSON.parseObject(position, CoordDTO.class);
	}

}
