package com.yeejoin.amos;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;
import org.typroject.tyboot.core.restful.utils.oConvertUtils;

import java.net.InetAddress;

@EnableAsync
@EnableEurekaClient
@MapperScan(value = {"org.typroject.tyboot.*.*.face.orm.dao","com.yeejoin.amos.api.*.face.orm.dao"})
@ComponentScan({"org.typroject", "com.yeejoin.amos"})
@SpringBootApplication
public class Application {

    private static final Logger log = LogManager.getLogger(Application.class);

    public static void main(String[] args) throws Exception {
        //服务启动
        ConfigurableApplicationContext context = SpringApplication.run(Application.class, args);
        GlobalExceptionHandler.setAlwaysOk(true);
        //打印doc地址
        Environment env = context.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = oConvertUtils.getString(env.getProperty("server.servlet.context-path"));
        log.info("\n----------------------------------------------------------\n\t"
                + "Application AMOS-API-TOOL is running! Access URLs:\n\t" + "Swagger文档: \thttp://" + ip + ":" + port
                + path + "/doc.html\n" + "----------------------------------------------------------");
    }
}


