package com.yeejoin.amos.api.tool.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.DataBaseNameListModel;
import com.yeejoin.amos.api.tool.face.service.DataBaseNameListService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.sql.SQLException;
import java.util.List;

@RestController
@Api(tags = "数据库名称表")
@RequestMapping(value = "/database_name")
public class DataBaseNameListResource {

    @Autowired
    private DataBaseNameListService dataBaseNameListService;

    /**
     * 数据库初始化
     *
     * @param ipSeq 数据库连接seq
     * @return List<DataBaseLinkModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/refresh/{ipSeq}")
    @ApiOperation(httpMethod = "POST", value = "数据库初始化", notes = "数据库初始化")
    public ResponseModel<List<String>> refresh(@PathVariable Long ipSeq) throws Exception {
        return ResponseHelper.buildResponse(
                dataBaseNameListService.refreshDataBase(ipSeq));
    }

    /**
     * 分页查询
     *
     * @param current 当前分页
     * @param size    分页大小
     * @return Page<DataBaseNameListModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<DataBaseNameListModel>> queryForPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam  Long ipSeq) throws SQLException, ClassNotFoundException {
        Page<DataBaseNameListModel> page = new Page<>();
        return ResponseHelper.buildResponse(dataBaseNameListService.queryForDataBasePage(page, ipSeq,current,size));
    }

}
