package com.yeejoin.amos.api.tool.controller;

import com.yeejoin.amos.api.tool.face.service.DataBaseLinkService;
import com.yeejoin.amos.api.tool.face.service.RelationService;
import com.yeejoin.amos.api.tool.face.service.StudioResourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;


@CrossOrigin
@RestController
@Api(tags = "机构管理Api")
@RequestMapping(value = "/agency")
public class RelationResource {
    @Autowired
    private RelationService relationService;
    @Autowired
    DataBaseLinkService dataBaseLinkService;
    @Autowired
    private StudioResourceService studioResourceService;

    /**
     * 根据机构ID和数据库sequenceNbr批量删除数据库
     *
     * @param agencyCode   机构ID
     * @param sequenceNbrs 多个主键
     * @return String
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/relation/{agencyCode}/{sequenceNbrs}")
    @ApiOperation(httpMethod = "DELETE", value = "机构删除", notes = "机构删除")
    public ResponseModel<String> deleteDataBase(
            @PathVariable String agencyCode,
            @PathVariable String sequenceNbrs) throws Exception {
        relationService.deleteAgency(agencyCode, sequenceNbrs);
        return ResponseHelper.buildResponse("The data has been deleted !");
    }

    /**
     * 导出SQL脚本
     *
     * @return String
     */
//    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
//    @GetMapping(value = "/export/{agencyCode}/{sequenceNbrs}")
//    @ApiOperation(httpMethod = "GET", value = "导出", notes = "导出")
////    public ResponseModel<String> generateSQL(
////    @RequestParam(value = "databaseName",required = false) String databaseName,
//    public void generateSQL(
//            @PathVariable String agencyCode,
//            @PathVariable String sequenceNbrs,
//            HttpServletResponse response,
//            HttpServletRequest request) throws Exception {
//        Map<String, Object> variables = new HashMap<>();
//        variables.put("agencyCode", agencyCode);
//        String referer = request.getHeader("Referer");
//        int start = referer.indexOf("ipSeq=")+6;
//        int end = referer.indexOf("&agencyCode=");
//        String ipSeq = referer.substring(start,end);
//        Long longIpSql = Long.parseLong(ipSeq);
//        studioResourceService.generateSQL("Agency","agencyCode", longIpSql, variables, response);
//        studioResourceService.generateSQLByDatabaseName("Agency","agencyCode",databaseName, longIpSql, variables, response);
////        return ResponseHelper.buildResponse("yes");
//    }


    /**
     * 导出SQL脚本
     *
     * @return String
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/export/{agencyCode}/{ipSeq}/{dbName}")
    @ApiOperation(httpMethod = "GET", value = "导出", notes = "导出")
//    public ResponseModel<String> generateSQL(
//    @RequestParam(value = "databaseName",required = false) String databaseName,
    public void generateSQL(
            @PathVariable String agencyCode,
            @PathVariable Long ipSeq,
            @PathVariable String dbName,
            HttpServletResponse response,
            HttpServletRequest request) throws Exception {
        Map<String, Object> variables = new HashMap<>();
        variables.put("agencyCode", agencyCode);
//        String referer = request.getHeader("Referer");
//        int start = referer.indexOf("ipSeq=")+6;
//        int end = referer.indexOf("&agencyCode=");
//        String ipSeq = referer.substring(start,end);
//        studioResourceService.generateSQL("Agency","agencyCode", ipSeq, variables, response);
        studioResourceService.generateSQLByDatabaseName("Agency","agencyCode",dbName, ipSeq, variables, response);
//        return ResponseHelper.buildResponse("yes");
    }


//    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
//    @GetMapping(value = "/export/{agencyCode}/{ipSeq}/{dbName}")
//    @ApiOperation(httpMethod = "GET", value = "导出", notes = "导出")
//    public ResponseModel<String> generateSQL(
//            @PathVariable String agencyCode,
//            @PathVariable Long ipSeq,
//            @PathVariable String dbName,
//            HttpServletResponse response) throws Exception {
//        relationService.outputAgency(agencyCode, ipSeq,dbName,response);
//        return ResponseHelper.buildResponse("yes");
//    }



}