package com.yeejoin.amos.api.tool.enums;

public enum SortType {
    COMPREHENSIVE("综合排序", "SEQUENCE_NBR", "asc"),
    LATEST("最新发布", "REC_DATE", "desc"),
    VIEW_TIMES("最多浏览", "VIEW_TIMES", "desc");

    private String name;
    private String field;
    private String direction;

    SortType(String name, String field, String direction) {
        this.name = name;
        this.field = field;
        this.direction = direction;
    }

    public String getName() {
        return name;
    }

    public String getField() {
        return field;
    }

    public String getDirection() {
        return direction;
    }

    public static SortType fromName(String name) {
        for (SortType sortType : SortType.values()) {
            if (sortType.getName().equals(name)) {
                return sortType;
            }
        }
        // 默认返回综合排序
        return COMPREHENSIVE;
    }
}
