package com.yeejoin.amos.api.tool.face.service;

import com.yeejoin.amos.api.tool.face.orm.entity.ApiInfo;
import com.yeejoin.amos.api.tool.face.orm.dao.ApiInfoMapper;
import com.yeejoin.amos.api.tool.face.model.ApiInfoModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.ArrayList;
import java.util.List;

@Service
public class ApiInfoService extends BaseService<ApiInfoModel,ApiInfo,ApiInfoMapper> {

    /**
     * 分页查询
     */
    public Page<ApiInfoModel> queryForApiInfoPage(Page<ApiInfoModel> page,String apiSource ,String apiName)   {
        return this.queryForPage(page ,null ,false ,apiSource ,apiName);
    }

    /**
     * 列表查询
     */
    public List<ApiInfoModel> queryForApiInfoList()   {
        return this.queryForList("" , false);
    }

    /**
     * 根据来源获取Api列表
     */
    public List<ApiInfoModel> selectByApiSource(String apiSource)   {
        return this.queryForList("" , false,apiSource);
    }

    /**
     * 根据来源获取Api列表主键
     */
    public List<String> selectSeqByApiSource(String apiSource) {
        List<String> sequenceNbrs = new ArrayList<>();
        for(ApiInfoModel model : this.selectByApiSource(apiSource)){
            sequenceNbrs.add(Long.toString(model.getSequenceNbr()));
        }
        return sequenceNbrs;
    }



}
